/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coreimage.CIImage;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIFilterInputParameters
extends NSDictionaryWrapper {
    CIFilterInputParameters(NSDictionary data) {
        super(data);
    }

    public CIFilterInputParameters() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CIFilterInputParameters set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public CIImage getOutputImage() {
        if (this.has(Keys.OutputImage())) {
            CIImage val = (CIImage)this.get(Keys.OutputImage());
            return val;
        }
        return null;
    }

    public CIFilterInputParameters setOutputImage(CIImage outputImage) {
        this.set(Keys.OutputImage(), (NSObject)outputImage);
        return this;
    }

    public CIImage getBackgroundImage() {
        if (this.has(Keys.BackgroundImage())) {
            CIImage val = (CIImage)this.get(Keys.BackgroundImage());
            return val;
        }
        return null;
    }

    public CIFilterInputParameters setBackgroundImage(CIImage backgroundImage) {
        this.set(Keys.BackgroundImage(), (NSObject)backgroundImage);
        return this;
    }

    public CIImage getInputImage() {
        if (this.has(Keys.Image())) {
            CIImage val = (CIImage)this.get(Keys.Image());
            return val;
        }
        return null;
    }

    public CIFilterInputParameters setInputImage(CIImage inputImage) {
        this.set(Keys.Image(), (NSObject)inputImage);
        return this;
    }

    public long getVersion() {
        if (this.has(Keys.Version())) {
            NSNumber val = (NSNumber)this.get(Keys.Version());
            return val.longValue();
        }
        return 0L;
    }

    public CIFilterInputParameters setVersion(long version) {
        this.set(Keys.Version(), (NSObject)NSNumber.valueOf(version));
        return this;
    }

    public boolean has(String key) {
        return this.has(new NSString(key));
    }

    public NSObject get(String key) {
        return this.get(new NSString(key));
    }

    public CIFilterInputParameters set(String key, NSObject value) {
        return this.set(new NSString(key), value);
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="kCIOutputImageKey", optional=true)
        public static native NSString OutputImage();

        @GlobalValue(symbol="kCIInputBackgroundImageKey", optional=true)
        public static native NSString BackgroundImage();

        @GlobalValue(symbol="kCIInputImageKey", optional=true)
        public static native NSString Image();

        @GlobalValue(symbol="kCIInputDepthImageKey", optional=true)
        public static native NSString DepthImage();

        @GlobalValue(symbol="kCIInputDisparityImageKey", optional=true)
        public static native NSString DisparityImage();

        @GlobalValue(symbol="kCIInputRefractionKey", optional=true)
        public static native NSString Refraction();

        @GlobalValue(symbol="kCIInputBiasKey", optional=true)
        public static native NSString Bias();

        @GlobalValue(symbol="kCIInputWeightsKey", optional=true)
        public static native NSString Weights();

        @GlobalValue(symbol="kCIInputGradientImageKey", optional=true)
        public static native NSString GradientImage();

        @GlobalValue(symbol="kCIInputShadingImageKey", optional=true)
        public static native NSString ShadingImage();

        @GlobalValue(symbol="kCIInputVersionKey", optional=true)
        public static native NSString Version();

        @GlobalValue(symbol="kCIInputAllowDraftModeKey", optional=true)
        public static native NSString AllowDraftMode();

        @GlobalValue(symbol="kCIInputDecoderVersionKey", optional=true)
        public static native NSString DecoderVersion();

        @GlobalValue(symbol="kCISupportedDecoderVersionsKey", optional=true)
        public static native String SupportedDecoderVersions();

        @GlobalValue(symbol="kCIInputBaselineExposureKey", optional=true)
        public static native NSString BaselineExposure();

        @GlobalValue(symbol="kCIInputBoostKey", optional=true)
        public static native NSString Boost();

        @GlobalValue(symbol="kCIInputBoostShadowAmountKey", optional=true)
        public static native NSString BoostShadowAmount();

        @GlobalValue(symbol="kCIInputDisableGamutMapKey", optional=true)
        public static native NSString DisableGamutMap();

        @GlobalValue(symbol="kCIInputNeutralChromaticityXKey", optional=true)
        public static native NSString NeutralChromaticityX();

        @GlobalValue(symbol="kCIInputNeutralChromaticityYKey", optional=true)
        public static native NSString NeutralChromaticityY();

        @GlobalValue(symbol="kCIInputNeutralTemperatureKey", optional=true)
        public static native NSString NeutralTemperature();

        @GlobalValue(symbol="kCIInputNeutralTintKey", optional=true)
        public static native NSString NeutralTint();

        @GlobalValue(symbol="kCIInputNeutralLocationKey", optional=true)
        public static native NSString NeutralLocation();

        @GlobalValue(symbol="kCIInputScaleFactorKey", optional=true)
        public static native NSString ScaleFactor();

        @GlobalValue(symbol="kCIInputIgnoreImageOrientationKey", optional=true)
        public static native NSString IgnoreImageOrientation();

        @GlobalValue(symbol="kCIInputImageOrientationKey", optional=true)
        public static native NSString ImageOrientation();

        @GlobalValue(symbol="kCIInputEnableSharpeningKey", optional=true)
        public static native NSString EnableSharpening();

        @GlobalValue(symbol="kCIInputEnableChromaticNoiseTrackingKey", optional=true)
        public static native NSString EnableChromaticNoiseTracking();

        @GlobalValue(symbol="kCIInputNoiseReductionAmountKey", optional=true)
        public static native NSString NoiseReductionAmount();

        @GlobalValue(symbol="kCIInputMoireAmountKey", optional=true)
        public static native NSString MoireAmount();

        @GlobalValue(symbol="kCIInputEnableVendorLensCorrectionKey", optional=true)
        public static native NSString EnableVendorLensCorrection();

        @GlobalValue(symbol="kCIInputLuminanceNoiseReductionAmountKey", optional=true)
        public static native NSString LuminanceNoiseReductionAmount();

        @GlobalValue(symbol="kCIInputColorNoiseReductionAmountKey", optional=true)
        public static native NSString ColorNoiseReductionAmount();

        @GlobalValue(symbol="kCIInputNoiseReductionSharpnessAmountKey", optional=true)
        public static native NSString NoiseReductionSharpnessAmount();

        @GlobalValue(symbol="kCIInputNoiseReductionContrastAmountKey", optional=true)
        public static native NSString NoiseReductionContrastAmount();

        @GlobalValue(symbol="kCIInputNoiseReductionDetailAmountKey", optional=true)
        public static native NSString NoiseReductionDetailAmount();

        @GlobalValue(symbol="kCIInputLinearSpaceFilter", optional=true)
        public static native String LinearSpaceFilter();

        @GlobalValue(symbol="kCIOutputNativeSizeKey", optional=true)
        public static native String NativeSize();

        @GlobalValue(symbol="kCIActiveKeys", optional=true)
        public static native String ActiveKeys();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIFilterInputParameters> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIFilterInputParameters> list = new ArrayList<CIFilterInputParameters>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIFilterInputParameters((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIFilterInputParameters> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIFilterInputParameters i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIFilterInputParameters toObject(Class<CIFilterInputParameters> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIFilterInputParameters(o);
        }

        @MarshalsPointer
        public static long toNative(CIFilterInputParameters o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

