/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.CIColorExtensions;
import org.robovm.apple.uikit.UIColor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreImage")
@NativeClass
public class CIColor
extends NSObject {
    public CIColor() {
    }

    protected CIColor(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CIColor(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithRed:green:blue:alpha:colorSpace:")
    public CIColor(@MachineSizedFloat double r, @MachineSizedFloat double g, @MachineSizedFloat double b, @MachineSizedFloat double a, CGColorSpace colorSpace) {
        super(null);
        this.initObject(this.init(r, g, b, a, colorSpace));
    }

    @Method(selector="initWithRed:green:blue:colorSpace:")
    public CIColor(@MachineSizedFloat double r, @MachineSizedFloat double g, @MachineSizedFloat double b, CGColorSpace colorSpace) {
        super(null);
        this.initObject(this.init(r, g, b, colorSpace));
    }

    public CIColor(double r, double g, double b, double a) {
        super(null, CIColor.create(r, g, b, a));
    }

    public CIColor(double r, double g, double b) {
        super(null, CIColor.create(r, g, b));
    }

    public CIColor(String representation) {
        super(null, CIColor.create(representation));
    }

    @Property(selector="numberOfComponents")
    @MachineSizedUInt
    public native long getNumberOfComponents();

    @Property(selector="components")
    protected native MachineSizedFloatPtr getComponents();

    @Property(selector="alpha")
    @MachineSizedFloat
    public native double getAlpha();

    @Property(selector="colorSpace")
    public native CGColorSpace getColorSpace();

    @Property(selector="red")
    @MachineSizedFloat
    public native double getRed();

    @Property(selector="green")
    @MachineSizedFloat
    public native double getGreen();

    @Property(selector="blue")
    @MachineSizedFloat
    public native double getBlue();

    @Property(selector="stringRepresentation")
    public native String getStringRepresentation();

    @Property(selector="blackColor")
    public static native CIColor blackColor();

    @Property(selector="whiteColor")
    public static native CIColor whiteColor();

    @Property(selector="grayColor")
    public static native CIColor grayColor();

    @Property(selector="redColor")
    public static native CIColor redColor();

    @Property(selector="greenColor")
    public static native CIColor greenColor();

    @Property(selector="blueColor")
    public static native CIColor blueColor();

    @Property(selector="cyanColor")
    public static native CIColor cyanColor();

    @Property(selector="magentaColor")
    public static native CIColor magentaColor();

    @Property(selector="yellowColor")
    public static native CIColor yellowColor();

    @Property(selector="clearColor")
    public static native CIColor clearColor();

    public double[] getComponentsD() {
        return this.getComponents().toDoubleArray((int)this.getNumberOfComponents());
    }

    public float[] getComponentsF() {
        return this.getComponents().toFloatArray((int)this.getNumberOfComponents());
    }

    @WeaklyLinked
    public static CIColor fromUIColor(UIColor color) {
        return CIColorExtensions.create(color);
    }

    @Method(selector="initWithRed:green:blue:alpha:colorSpace:")
    @Pointer
    protected native long init(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, CGColorSpace var9);

    @Method(selector="initWithRed:green:blue:colorSpace:")
    @Pointer
    protected native long init(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, CGColorSpace var7);

    @Method(selector="colorWithCGColor:")
    @Pointer
    protected static native long create(CGColor var0);

    @Method(selector="colorWithRed:green:blue:alpha:")
    @Pointer
    protected static native long create(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6);

    @Method(selector="colorWithRed:green:blue:")
    @Pointer
    protected static native long create(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4);

    @Method(selector="colorWithRed:green:blue:alpha:colorSpace:")
    @Pointer
    protected static native long create(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4, @MachineSizedFloat double var6, CGColorSpace var8);

    @Method(selector="colorWithRed:green:blue:colorSpace:")
    @Pointer
    protected static native long create(@MachineSizedFloat double var0, @MachineSizedFloat double var2, @MachineSizedFloat double var4, CGColorSpace var6);

    @Method(selector="colorWithString:")
    @Pointer
    protected static native long create(String var0);

    static {
        ObjCRuntime.bind(CIColor.class);
    }

    public static class CIColorPtr
    extends Ptr<CIColor, CIColorPtr> {
    }
}

