/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRectEdge;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIEdgeInsets;
import org.robovm.apple.uikit.UIGeometry;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGRect
extends Struct<CGRect> {
    public CGRect() {
    }

    public CGRect(CGPoint origin, CGSize size) {
        this.setOrigin(origin);
        this.setSize(size);
    }

    public CGRect(double x, double y, double width, double height) {
        this.getOrigin().setX(x).setY(y);
        this.getSize().setWidth(width).setHeight(height);
    }

    @StructMember(value=0)
    @ByVal
    public native CGPoint getOrigin();

    @StructMember(value=0)
    public native CGRect setOrigin(@ByVal CGPoint var1);

    @StructMember(value=1)
    @ByVal
    public native CGSize getSize();

    @StructMember(value=1)
    public native CGRect setSize(@ByVal CGSize var1);

    @WeaklyLinked
    public static CGRect fromString(String string) {
        return UIGeometry.stringToCGRect(string);
    }

    public static CGRect fromDictionary(NSDictionary<NSString, NSNumber> dict) {
        CGRect r = new CGRect();
        if (!CGRect.fromDictionary(dict, r)) {
            throw new IllegalArgumentException("Failed to create CGRect from dictionary " + dict);
        }
        return r;
    }

    @WeaklyLinked
    public CGRect inset(UIEdgeInsets insets) {
        this.getOrigin().setX(this.getOrigin().getX() + insets.getLeft());
        this.getOrigin().setY(this.getOrigin().getY() + insets.getTop());
        this.getSize().setWidth(this.getSize().getWidth() - (insets.getLeft() + insets.getRight()));
        this.getSize().setHeight(this.getSize().getHeight() - (insets.getTop() + insets.getBottom()));
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof CGRect && CGRect.equalsTo(this, (CGRect)((Object)obj));
    }

    @WeaklyLinked
    public String toString() {
        return UIGeometry.toString(this);
    }

    @GlobalValue(symbol="CGRectZero", optional=true)
    @ByVal
    public static native CGRect Zero();

    @GlobalValue(symbol="CGRectNull", optional=true)
    @ByVal
    public static native CGRect Null();

    @GlobalValue(symbol="CGRectInfinite", optional=true)
    @ByVal
    public static native CGRect Infinite();

    @MachineSizedFloat
    public double getMinX() {
        return CGRect.getMinX(this);
    }

    @Bridge(symbol="CGRectGetMinX", optional=true)
    @MachineSizedFloat
    private static native double getMinX(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getMidX() {
        return CGRect.getMidX(this);
    }

    @Bridge(symbol="CGRectGetMidX", optional=true)
    @MachineSizedFloat
    private static native double getMidX(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getMaxX() {
        return CGRect.getMaxX(this);
    }

    @Bridge(symbol="CGRectGetMaxX", optional=true)
    @MachineSizedFloat
    private static native double getMaxX(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getMinY() {
        return CGRect.getMinY(this);
    }

    @Bridge(symbol="CGRectGetMinY", optional=true)
    @MachineSizedFloat
    private static native double getMinY(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getMidY() {
        return CGRect.getMidY(this);
    }

    @Bridge(symbol="CGRectGetMidY", optional=true)
    @MachineSizedFloat
    private static native double getMidY(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getMaxY() {
        return CGRect.getMaxY(this);
    }

    @Bridge(symbol="CGRectGetMaxY", optional=true)
    @MachineSizedFloat
    private static native double getMaxY(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getWidth() {
        return CGRect.getWidth(this);
    }

    @Bridge(symbol="CGRectGetWidth", optional=true)
    @MachineSizedFloat
    private static native double getWidth(@ByVal CGRect var0);

    @MachineSizedFloat
    public double getHeight() {
        return CGRect.getHeight(this);
    }

    @Bridge(symbol="CGRectGetHeight", optional=true)
    @MachineSizedFloat
    private static native double getHeight(@ByVal CGRect var0);

    public boolean equalsTo(CGRect rect2) {
        return CGRect.equalsTo(this, rect2);
    }

    @Bridge(symbol="CGRectEqualToRect", optional=true)
    private static native boolean equalsTo(@ByVal CGRect var0, @ByVal CGRect var1);

    public CGRect standardize() {
        return CGRect.standardize(this);
    }

    @Bridge(symbol="CGRectStandardize", optional=true)
    @ByVal
    private static native CGRect standardize(@ByVal CGRect var0);

    public boolean isEmpty() {
        return CGRect.isEmpty(this);
    }

    @Bridge(symbol="CGRectIsEmpty", optional=true)
    private static native boolean isEmpty(@ByVal CGRect var0);

    public boolean isNull() {
        return CGRect.isNull(this);
    }

    @Bridge(symbol="CGRectIsNull", optional=true)
    private static native boolean isNull(@ByVal CGRect var0);

    public boolean isInfinite() {
        return CGRect.isInfinite(this);
    }

    @Bridge(symbol="CGRectIsInfinite", optional=true)
    private static native boolean isInfinite(@ByVal CGRect var0);

    public CGRect inset(@MachineSizedFloat double dx, @MachineSizedFloat double dy) {
        return CGRect.inset(this, dx, dy);
    }

    @Bridge(symbol="CGRectInset", optional=true)
    @ByVal
    private static native CGRect inset(@ByVal CGRect var0, @MachineSizedFloat double var1, @MachineSizedFloat double var3);

    public CGRect integral() {
        return CGRect.integral(this);
    }

    @Bridge(symbol="CGRectIntegral", optional=true)
    @ByVal
    private static native CGRect integral(@ByVal CGRect var0);

    public CGRect union(CGRect r2) {
        return CGRect.union(this, r2);
    }

    @Bridge(symbol="CGRectUnion", optional=true)
    @ByVal
    private static native CGRect union(@ByVal CGRect var0, @ByVal CGRect var1);

    public CGRect intersection(CGRect r2) {
        return CGRect.intersection(this, r2);
    }

    @Bridge(symbol="CGRectIntersection", optional=true)
    @ByVal
    private static native CGRect intersection(@ByVal CGRect var0, @ByVal CGRect var1);

    public CGRect offset(@MachineSizedFloat double dx, @MachineSizedFloat double dy) {
        return CGRect.offset(this, dx, dy);
    }

    @Bridge(symbol="CGRectOffset", optional=true)
    @ByVal
    private static native CGRect offset(@ByVal CGRect var0, @MachineSizedFloat double var1, @MachineSizedFloat double var3);

    public void divide(CGRect slice, CGRect remainder, @MachineSizedFloat double amount, CGRectEdge edge) {
        CGRect.divide(this, slice, remainder, amount, edge);
    }

    @Bridge(symbol="CGRectDivide", optional=true)
    private static native void divide(@ByVal CGRect var0, CGRect var1, CGRect var2, @MachineSizedFloat double var3, CGRectEdge var5);

    public boolean contains(CGPoint point) {
        return CGRect.contains(this, point);
    }

    @Bridge(symbol="CGRectContainsPoint", optional=true)
    private static native boolean contains(@ByVal CGRect var0, @ByVal CGPoint var1);

    public boolean contains(CGRect rect2) {
        return CGRect.contains(this, rect2);
    }

    @Bridge(symbol="CGRectContainsRect", optional=true)
    private static native boolean contains(@ByVal CGRect var0, @ByVal CGRect var1);

    public boolean intersects(CGRect rect2) {
        return CGRect.intersects(this, rect2);
    }

    @Bridge(symbol="CGRectIntersectsRect", optional=true)
    private static native boolean intersects(@ByVal CGRect var0, @ByVal CGRect var1);

    public NSDictionary<NSString, NSNumber> toDictionary() {
        return CGRect.toDictionary(this);
    }

    @Bridge(symbol="CGRectCreateDictionaryRepresentation", optional=true)
    private static native NSDictionary<NSString, NSNumber> toDictionary(@ByVal CGRect var0);

    @Bridge(symbol="CGRectMakeWithDictionaryRepresentation", optional=true)
    private static native boolean fromDictionary(NSDictionary<NSString, NSNumber> var0, CGRect var1);

    public CGRect apply(CGAffineTransform t) {
        return CGRect.apply(this, t);
    }

    @Bridge(symbol="CGRectApplyAffineTransform", optional=true)
    @ByVal
    private static native CGRect apply(@ByVal CGRect var0, @ByVal CGAffineTransform var1);

    public double getX() {
        return this.getOrigin().getX();
    }

    public double getY() {
        return this.getOrigin().getY();
    }

    public CGRect setX(double x) {
        this.getOrigin().setX(x);
        return this;
    }

    public CGRect setY(double y) {
        this.getOrigin().setY(y);
        return this;
    }

    public CGRect setWidth(double w) {
        this.getSize().setWidth(w);
        return this;
    }

    public CGRect setHeight(double h) {
        this.getSize().setHeight(h);
        return this;
    }

    static {
        Bro.bind(CGRect.class);
    }

    public static class CGRectPtr
    extends Ptr<CGRect, CGRectPtr> {
    }
}

