/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.lang.reflect.Method;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGLineCap;
import org.robovm.apple.coregraphics.CGLineJoin;
import org.robovm.apple.coregraphics.CGPathElement;
import org.robovm.apple.coregraphics.CGPathElementType;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CoreGraphics;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGPath
extends CFType {
    private static final Method cbApplier;

    protected CGPath() {
    }

    public static CGPath createCopyByDashingPath(CGPath path, CGAffineTransform transform, double phase, double[] lengths) {
        return CGPath.createCopyByDashingPath(path, transform, phase, lengths != null ? VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(lengths)) : 0L, lengths != null ? (long)lengths.length : 0L);
    }

    public static CGPath createCopyByDashingPath(CGPath path, CGAffineTransform transform, double phase, float[] lengths) {
        return CGPath.createCopyByDashingPath(path, transform, phase, lengths != null ? VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(lengths)) : 0L, lengths != null ? (long)lengths.length : 0L);
    }

    public void apply(Applier applier) {
        if (applier == null) {
            throw new NullPointerException("applier");
        }
        this.apply(VM.getObjectAddress((Object)applier), VM.getCallbackMethodImpl((Method)cbApplier));
    }

    @Callback
    private static void cbApplier(@Pointer long applierPtr, CGPathElement element) {
        Applier applier = (Applier)VM.castAddressToObject((long)applierPtr);
        CGPoint point1 = null;
        CGPoint point2 = null;
        CGPoint point3 = null;
        switch (element.getType()) {
            case AddLineToPoint: 
            case MoveToPoint: {
                point1 = element.getPoints();
                break;
            }
            case AddQuadCurveToPoint: {
                point1 = element.getPoints();
                point2 = (CGPoint)point1.next();
                break;
            }
            case AddCurveToPoint: {
                point1 = element.getPoints();
                point2 = (CGPoint)point1.next();
                point3 = (CGPoint)point2.next();
                break;
            }
        }
        applier.apply(element.getType(), point1, point2, point3);
    }

    @Bridge(symbol="CGPathGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGPathCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createCopy(CGPath var0);

    @Bridge(symbol="CGPathCreateCopyByTransformingPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createCopyByTransformingPath(CGPath var0, CGAffineTransform var1);

    @Bridge(symbol="CGPathCreateWithRect", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createWithRect(@ByVal CGRect var0, CGAffineTransform var1);

    @Bridge(symbol="CGPathCreateWithEllipseInRect", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createWithEllipseInRect(@ByVal CGRect var0, CGAffineTransform var1);

    @Bridge(symbol="CGPathCreateWithRoundedRect", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createWithRoundedRect(@ByVal CGRect var0, @MachineSizedFloat double var1, @MachineSizedFloat double var3, CGAffineTransform var5);

    @Bridge(symbol="CGPathCreateCopyByDashingPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGPath createCopyByDashingPath(CGPath var0, CGAffineTransform var1, @MachineSizedFloat double var2, @Pointer long var4, @MachineSizedUInt long var6);

    @Bridge(symbol="CGPathCreateCopyByStrokingPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGPath createCopyByStrokingPath(CGPath var0, CGAffineTransform var1, @MachineSizedFloat double var2, CGLineCap var4, CGLineJoin var5, @MachineSizedFloat double var6);

    @Bridge(symbol="CGPathEqualToPath", optional=true)
    public native boolean equalsTo(CGPath var1);

    @Bridge(symbol="CGPathIsEmpty", optional=true)
    public native boolean isEmpty();

    @Bridge(symbol="CGPathIsRect", optional=true)
    public native boolean isRect(CGRect var1);

    @Bridge(symbol="CGPathGetCurrentPoint", optional=true)
    @ByVal
    public native CGPoint getCurrentPoint();

    @Bridge(symbol="CGPathGetBoundingBox", optional=true)
    @ByVal
    public native CGRect getBoundingBox();

    @Bridge(symbol="CGPathGetPathBoundingBox", optional=true)
    @ByVal
    public native CGRect getPathBoundingBox();

    @Bridge(symbol="CGPathContainsPoint", optional=true)
    public native boolean containsPoint(CGAffineTransform var1, @ByVal CGPoint var2, boolean var3);

    @Bridge(symbol="CGPathApply", optional=true)
    private native void apply(@Pointer long var1, @Pointer long var3);

    static {
        Bro.bind(CGPath.class);
        try {
            cbApplier = CGPath.class.getDeclaredMethod("cbApplier", Long.TYPE, CGPathElement.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static interface Applier {
        public void apply(CGPathElementType var1, CGPoint var2, CGPoint var3, CGPoint var4);
    }

    public static class CGPathPtr
    extends Ptr<CGPath, CGPathPtr> {
    }
}

