/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGPDFArray;
import org.robovm.apple.coregraphics.CGPDFObject;
import org.robovm.apple.coregraphics.CGPDFStream;
import org.robovm.apple.coregraphics.CGPDFString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.StringMarshalers;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGPDFDictionary
extends NativeObject {
    protected CGPDFDictionary() {
    }

    public boolean hasObject(String key) {
        CGPDFObject.CGPDFObjectPtr ptr = new CGPDFObject.CGPDFObjectPtr();
        return this.getObject(key, ptr);
    }

    public CGPDFObject getObject(String key) {
        CGPDFObject.CGPDFObjectPtr ptr = new CGPDFObject.CGPDFObjectPtr();
        if (this.getObject(key, ptr)) {
            return (CGPDFObject)ptr.get();
        }
        return null;
    }

    public boolean hasBoolean(String key) {
        BooleanPtr ptr = new BooleanPtr();
        return this.getBoolean(key, ptr);
    }

    public boolean getBoolean(String key) {
        BooleanPtr ptr = new BooleanPtr();
        if (this.getBoolean(key, ptr)) {
            return ptr.get();
        }
        return false;
    }

    public boolean hasLong(String key) {
        MachineSizedSIntPtr ptr = new MachineSizedSIntPtr();
        return this.getInteger(key, ptr);
    }

    public long getLong(String key) {
        MachineSizedSIntPtr ptr = new MachineSizedSIntPtr();
        if (this.getInteger(key, ptr)) {
            return ptr.get();
        }
        return 0L;
    }

    public boolean hasDouble(String key) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        return this.getNumber(key, ptr);
    }

    public double getDouble(String key) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        if (this.getNumber(key, ptr)) {
            return ptr.get();
        }
        return 0.0;
    }

    public boolean hasName(String key) {
        BytePtr.BytePtrPtr ptr = new BytePtr.BytePtrPtr();
        return this.getName(key, ptr);
    }

    public String getName(String key) {
        BytePtr.BytePtrPtr ptr = new BytePtr.BytePtrPtr();
        if (this.getName(key, ptr)) {
            return ((BytePtr)ptr.get()).toStringZ();
        }
        return null;
    }

    public boolean hasString(String key) {
        CGPDFString.CGPDFStringPtr ptr = new CGPDFString.CGPDFStringPtr();
        return this.getString(key, ptr);
    }

    public CGPDFString getString(String key) {
        CGPDFString.CGPDFStringPtr ptr = new CGPDFString.CGPDFStringPtr();
        if (this.getString(key, ptr)) {
            return (CGPDFString)ptr.get();
        }
        return null;
    }

    public boolean hasArray(String key) {
        CGPDFArray.CGPDFArrayPtr ptr = new CGPDFArray.CGPDFArrayPtr();
        return this.getArray(key, ptr);
    }

    public CGPDFArray getArray(String key) {
        CGPDFArray.CGPDFArrayPtr ptr = new CGPDFArray.CGPDFArrayPtr();
        if (this.getArray(key, ptr)) {
            return (CGPDFArray)ptr.get();
        }
        return null;
    }

    public boolean hasDictionary(String key) {
        CGPDFDictionaryPtr ptr = new CGPDFDictionaryPtr();
        return this.getDictionary(key, ptr);
    }

    public CGPDFDictionary getDictionary(String key) {
        CGPDFDictionaryPtr ptr = new CGPDFDictionaryPtr();
        if (this.getDictionary(key, ptr)) {
            return (CGPDFDictionary)ptr.get();
        }
        return null;
    }

    public boolean hasStream(String key) {
        CGPDFStream.CGPDFStreamPtr ptr = new CGPDFStream.CGPDFStreamPtr();
        return this.getStream(key, ptr);
    }

    public CGPDFStream getStream(String key) {
        CGPDFStream.CGPDFStreamPtr ptr = new CGPDFStream.CGPDFStreamPtr();
        if (this.getStream(key, ptr)) {
            return (CGPDFStream)ptr.get();
        }
        return null;
    }

    @Bridge(symbol="CGPDFDictionaryGetCount", optional=true)
    @MachineSizedUInt
    public native long size();

    @Bridge(symbol="CGPDFDictionaryGetObject", optional=true)
    private native boolean getObject(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, CGPDFObject.CGPDFObjectPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetBoolean", optional=true)
    private native boolean getBoolean(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, BooleanPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetInteger", optional=true)
    private native boolean getInteger(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, MachineSizedSIntPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetNumber", optional=true)
    private native boolean getNumber(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, MachineSizedFloatPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetName", optional=true)
    private native boolean getName(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, BytePtr.BytePtrPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetString", optional=true)
    private native boolean getString(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, CGPDFString.CGPDFStringPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetArray", optional=true)
    private native boolean getArray(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, CGPDFArray.CGPDFArrayPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetDictionary", optional=true)
    private native boolean getDictionary(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, CGPDFDictionaryPtr var2);

    @Bridge(symbol="CGPDFDictionaryGetStream", optional=true)
    private native boolean getStream(@Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class) String var1, CGPDFStream.CGPDFStreamPtr var2);

    static {
        Bro.bind(CGPDFDictionary.class);
    }

    public static class CGPDFDictionaryPtr
    extends Ptr<CGPDFDictionary, CGPDFDictionaryPtr> {
    }
}

