/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFError;
import org.robovm.apple.corefoundation.CFMutableData;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.corefoundation.CFRunLoopMode;
import org.robovm.apple.corefoundation.CFStreamClientContext;
import org.robovm.apple.corefoundation.CFStreamError;
import org.robovm.apple.corefoundation.CFStreamEventType;
import org.robovm.apple.corefoundation.CFStreamProperty;
import org.robovm.apple.corefoundation.CFStreamStatus;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.CFURL;
import org.robovm.apple.corefoundation.CFWriteStream;
import org.robovm.apple.coreservices.CFFTPStreamProperty;
import org.robovm.apple.coreservices.CFSocketStreamProperty;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.objc.LongMap;
import org.robovm.rt.VM;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFReadStream
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private static final LongMap<ClientCallback> clientCallbacks = new LongMap();
    private static final Method cbClient;
    private long localRefconId;

    protected CFReadStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbClient(CFReadStream stream, CFStreamEventType eventType, @Pointer long refcon) {
        ClientCallback callback = null;
        LongMap<ClientCallback> longMap = clientCallbacks;
        synchronized (longMap) {
            callback = (ClientCallback)clientCallbacks.get(refcon);
        }
        callback.invoke(stream, eventType);
    }

    public static CFReadStream create(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return CFReadStream.create(null, VM.getArrayValuesAddress((Object)bytes), bytes.length, null);
    }

    public static CFReadStream create(ByteBuffer bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        long handle = CFData.getEffectiveAddress(bytes) + (long)bytes.position();
        return CFReadStream.create(null, handle, bytes.remaining(), null);
    }

    public static CFReadStream create(CFURL fileURL) {
        return CFReadStream.create(null, fileURL);
    }

    public long read(BytePtr buffer, long len) {
        return this.read(buffer.getHandle(), len);
    }

    public long read(ByteBuffer bytes) {
        long handle = CFData.getEffectiveAddress(bytes) + (long)bytes.position();
        return this.read(handle, (long)bytes.remaining());
    }

    public long read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    public long read(byte[] bytes, int offset, int length) {
        CFMutableData.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return 0L;
        }
        return this.read(VM.getArrayValuesAddress((Object)bytes) + (long)offset, (long)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setClientCallback(CFStreamEventType streamEvents, ClientCallback callback) {
        this.localRefconId = refconId.getAndIncrement();
        CFStreamClientContext context = new CFStreamClientContext();
        context.setInfo(this.localRefconId);
        boolean result = this.setClient(streamEvents, new FunctionPtr(cbClient), context);
        if (result) {
            LongMap<ClientCallback> longMap = clientCallbacks;
            synchronized (longMap) {
                clientCallbacks.put(this.localRefconId, (Object)callback);
            }
        }
        return result;
    }

    public CFType getProperty(CFStreamProperty property) {
        return this.getProperty((CFString)property.value());
    }

    @WeaklyLinked
    public CFType getProperty(CFSocketStreamProperty property) {
        return this.getProperty((CFString)property.value());
    }

    @WeaklyLinked
    public CFType getProperty(CFFTPStreamProperty property) {
        return this.getProperty((CFString)property.value());
    }

    public boolean setProperty(CFStreamProperty property, CFType propertyValue) {
        return this.setProperty((CFString)property.value(), propertyValue);
    }

    @WeaklyLinked
    public boolean setProperty(CFSocketStreamProperty property, CFType propertyValue) {
        return this.setProperty((CFString)property.value(), propertyValue);
    }

    @WeaklyLinked
    public boolean setProperty(CFFTPStreamProperty property, CFType propertyValue) {
        return this.setProperty((CFString)property.value(), propertyValue);
    }

    public void scheduleInRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.scheduleInRunLoop(runLoop, ((CFString)runLoopMode.value()).toString());
    }

    public void unscheduleFromRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.unscheduleFromRunLoop(runLoop, ((CFString)runLoopMode.value()).toString());
    }

    @Bridge(symbol="CFReadStreamGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFReadStreamCreateWithBytesNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFReadStream create(CFAllocator var0, @Pointer long var1, @MachineSizedSInt long var3, CFAllocator var5);

    @Bridge(symbol="CFReadStreamCreateWithFile", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFReadStream create(CFAllocator var0, CFURL var1);

    @Bridge(symbol="CFReadStreamGetStatus", optional=true)
    public native CFStreamStatus getStatus();

    @Bridge(symbol="CFReadStreamCopyError", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFError getError();

    @Bridge(symbol="CFReadStreamOpen", optional=true)
    public native boolean openStream();

    @Bridge(symbol="CFReadStreamClose", optional=true)
    public native void closeStream();

    @Bridge(symbol="CFReadStreamHasBytesAvailable", optional=true)
    public native boolean hasBytesAvailable();

    @Bridge(symbol="CFReadStreamRead", optional=true)
    @MachineSizedSInt
    private native long read(@Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFReadStreamGetBuffer", optional=true)
    private native BytePtr getBuffer(@MachineSizedSInt long var1, MachineSizedSIntPtr var3);

    @Bridge(symbol="CFReadStreamCopyProperty", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private native CFType getProperty(CFString var1);

    @Bridge(symbol="CFReadStreamSetProperty", optional=true)
    private native boolean setProperty(CFString var1, CFType var2);

    @Bridge(symbol="CFReadStreamSetClient", optional=true)
    private native boolean setClient(CFStreamEventType var1, FunctionPtr var2, CFStreamClientContext var3);

    @Bridge(symbol="CFReadStreamScheduleWithRunLoop", optional=true)
    public native void scheduleInRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFReadStreamUnscheduleFromRunLoop", optional=true)
    public native void unscheduleFromRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFReadStreamSetDispatchQueue", optional=true)
    @WeaklyLinked
    public native void setDispatchQueue(DispatchQueue var1);

    @Bridge(symbol="CFReadStreamCopyDispatchQueue", optional=true)
    @WeaklyLinked
    public native DispatchQueue getDispatchQueue();

    @Bridge(symbol="CFReadStreamGetError", optional=true)
    @ByVal
    public native CFStreamError getStreamError();

    static {
        try {
            cbClient = CFWriteStream.class.getDeclaredMethod("cbClient", CFReadStream.class, CFStreamEventType.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFReadStream.class);
    }

    public static class CFReadStreamPtr
    extends Ptr<CFReadStream, CFReadStreamPtr> {
    }

    public static interface ClientCallback {
        public void invoke(CFReadStream var1, CFStreamEventType var2);
    }
}

