/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import org.robovm.apple.corefoundation.CFNotificationPostingOptions;
import org.robovm.apple.corefoundation.CFNotificationSuspensionBehavior;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFNotificationCenter
extends CFType {
    private static final LongMap<NotificationCallback> callbacks = new LongMap();
    private static final Method cbNotification;

    protected CFNotificationCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbNotification(CFNotificationCenter center, CFType observer, String name, CFType object, NSDictionary<NSString, ?> userInfo) {
        NotificationCallback callback = null;
        LongMap<NotificationCallback> longMap = callbacks;
        synchronized (longMap) {
            long id = CFNotificationCenter.getCallbackIdForNotification(observer, name, object);
            callback = (NotificationCallback)callbacks.get(id);
        }
        if (callback != null) {
            callback.invoke(center, observer, name, object, userInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(CFType observer, NotificationCallback callBack, String name, CFType object, CFNotificationSuspensionBehavior suspensionBehavior) {
        LongMap<NotificationCallback> longMap = callbacks;
        synchronized (longMap) {
            long id = CFNotificationCenter.getCallbackIdForNotification(observer, name, object);
            callbacks.put(id, (Object)callBack);
        }
        this.addObserver(observer, new FunctionPtr(cbNotification), name, object, suspensionBehavior);
    }

    private static long getCallbackIdForNotification(CFType observer, String name, CFType object) {
        int prime = 31;
        long id = name.hashCode();
        if (observer != null) {
            id = id * 31L + observer.hash();
        }
        if (object != null) {
            id = id * 31L + object.hash();
        }
        return id;
    }

    @Bridge(symbol="CFNotificationCenterGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFNotificationCenterGetLocalCenter", optional=true)
    public static native CFNotificationCenter getLocalCenter();

    @Bridge(symbol="CFNotificationCenterGetDarwinNotifyCenter", optional=true)
    public static native CFNotificationCenter getDarwinNotifyCenter();

    @Bridge(symbol="CFNotificationCenterAddObserver", optional=true)
    private native void addObserver(CFType var1, FunctionPtr var2, String var3, CFType var4, CFNotificationSuspensionBehavior var5);

    @Bridge(symbol="CFNotificationCenterRemoveObserver", optional=true)
    public native void removeObserver(CFType var1, String var2, CFType var3);

    @Bridge(symbol="CFNotificationCenterRemoveEveryObserver", optional=true)
    public native void removeEveryObserver(CFType var1);

    @Bridge(symbol="CFNotificationCenterPostNotification", optional=true)
    public native void postNotification(String var1, CFType var2, NSDictionary var3, boolean var4);

    @Bridge(symbol="CFNotificationCenterPostNotificationWithOptions", optional=true)
    public native void postNotification(String var1, CFType var2, NSDictionary var3, CFNotificationPostingOptions var4);

    static {
        try {
            cbNotification = CFNotificationCenter.class.getDeclaredMethod("cbNotification", CFNotificationCenter.class, CFType.class, String.class, CFType.class, NSDictionary.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFNotificationCenter.class);
    }

    public static class CFNotificationCenterPtr
    extends Ptr<CFNotificationCenter, CFNotificationCenterPtr> {
    }

    public static interface NotificationCallback {
        public void invoke(CFNotificationCenter var1, CFType var2, String var3, CFType var4, NSDictionary<NSString, ?> var5);
    }
}

