/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSFileProtection;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreData")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSPersistentStoreOptions
extends NSDictionaryWrapper {
    NSPersistentStoreOptions(NSDictionary data) {
        super(data);
    }

    public NSPersistentStoreOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSPersistentStoreOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean isReadOnly() {
        if (this.has(Keys.ReadOnly())) {
            NSNumber val = (NSNumber)this.get(Keys.ReadOnly());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setReadOnly(boolean readOnly) {
        this.set(Keys.ReadOnly(), NSNumber.valueOf(readOnly));
        return this;
    }

    public long getTimeout() {
        if (this.has(Keys.Timeout())) {
            NSNumber val = (NSNumber)this.get(Keys.Timeout());
            return val.longValue();
        }
        return 0L;
    }

    public NSPersistentStoreOptions setTimeout(long timeout) {
        this.set(Keys.Timeout(), NSNumber.valueOf(timeout));
        return this;
    }

    public Map<String, NSObject> getSQLitePragmas() {
        if (this.has(Keys.SQLitePragmas())) {
            NSDictionary val = (NSDictionary)this.get(Keys.SQLitePragmas());
            return val.asStringMap();
        }
        return null;
    }

    public NSPersistentStoreOptions setSQLitePragmas(Map<String, NSObject> sQLitePragmas) {
        this.set(Keys.SQLitePragmas(), NSDictionary.fromStringMap(sQLitePragmas));
        return this;
    }

    public boolean isSQLiteAnalyzeEnabled() {
        if (this.has(Keys.SQLiteAnalyze())) {
            NSNumber val = (NSNumber)this.get(Keys.SQLiteAnalyze());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setSQLiteAnalyzeEnabled(boolean sQLiteAnalyzeEnabled) {
        this.set(Keys.SQLiteAnalyze(), NSNumber.valueOf(sQLiteAnalyzeEnabled));
        return this;
    }

    public boolean isSQLiteManualVacuumEnabled() {
        if (this.has(Keys.SQLiteManualVacuum())) {
            NSNumber val = (NSNumber)this.get(Keys.SQLiteManualVacuum());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setSQLiteManualVacuumEnabled(boolean sQLiteManualVacuumEnabled) {
        this.set(Keys.SQLiteManualVacuum(), NSNumber.valueOf(sQLiteManualVacuumEnabled));
        return this;
    }

    public boolean ignoresPersistentStoreVersioning() {
        if (this.has(Keys.IgnorePersistentStoreVersioning())) {
            NSNumber val = (NSNumber)this.get(Keys.IgnorePersistentStoreVersioning());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setIgnoresPersistentStoreVersioning(boolean ignoresPersistentStoreVersioning) {
        this.set(Keys.IgnorePersistentStoreVersioning(), NSNumber.valueOf(ignoresPersistentStoreVersioning));
        return this;
    }

    public boolean migratesPersistentStoresAutomatically() {
        if (this.has(Keys.MigratePersistentStoresAutomatically())) {
            NSNumber val = (NSNumber)this.get(Keys.MigratePersistentStoresAutomatically());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setMigratesPersistentStoresAutomatically(boolean migratesPersistentStoresAutomatically) {
        this.set(Keys.MigratePersistentStoresAutomatically(), NSNumber.valueOf(migratesPersistentStoresAutomatically));
        return this;
    }

    public boolean infersMappingModelAutomatically() {
        if (this.has(Keys.InferMappingModelAutomatically())) {
            NSNumber val = (NSNumber)this.get(Keys.InferMappingModelAutomatically());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setInfersMappingModelAutomatically(boolean infersMappingModelAutomatically) {
        this.set(Keys.InferMappingModelAutomatically(), NSNumber.valueOf(infersMappingModelAutomatically));
        return this;
    }

    public boolean isForceDestroy() {
        if (this.has(Keys.ForceDestroy())) {
            NSNumber val = (NSNumber)this.get(Keys.ForceDestroy());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setForceDestroy(boolean forceDestroy) {
        this.set(Keys.ForceDestroy(), NSNumber.valueOf(forceDestroy));
        return this;
    }

    public NSFileProtection getFileProtection() {
        if (this.has(Keys.FileProtection())) {
            NSString val = (NSString)this.get(Keys.FileProtection());
            return NSFileProtection.valueOf(val);
        }
        return null;
    }

    public NSPersistentStoreOptions setFileProtection(NSFileProtection fileProtection) {
        this.set(Keys.FileProtection(), (NSObject)fileProtection.value());
        return this;
    }

    @Deprecated
    public String getUbiquitousContentName() {
        if (this.has(Keys.UbiquitousContentName())) {
            NSString val = (NSString)this.get(Keys.UbiquitousContentName());
            return val.toString();
        }
        return null;
    }

    @Deprecated
    public NSPersistentStoreOptions setUbiquitousContentName(String ubiquitousContentName) {
        this.set(Keys.UbiquitousContentName(), new NSString(ubiquitousContentName));
        return this;
    }

    @Deprecated
    public String getUbiquitousContentURL() {
        if (this.has(Keys.UbiquitousContentURL())) {
            NSString val = (NSString)this.get(Keys.UbiquitousContentURL());
            return val.toString();
        }
        return null;
    }

    @Deprecated
    public NSPersistentStoreOptions setUbiquitousContentURL(String ubiquitousContentURL) {
        this.set(Keys.UbiquitousContentURL(), new NSString(ubiquitousContentURL));
        return this;
    }

    @Deprecated
    public String getUbiquitousPeerToken() {
        if (this.has(Keys.UbiquitousPeerToken())) {
            NSString val = (NSString)this.get(Keys.UbiquitousPeerToken());
            return val.toString();
        }
        return null;
    }

    @Deprecated
    public NSPersistentStoreOptions setUbiquitousPeerToken(String ubiquitousPeerToken) {
        this.set(Keys.UbiquitousPeerToken(), new NSString(ubiquitousPeerToken));
        return this;
    }

    @Deprecated
    public boolean shouldRemoveUbiquitousMetadata() {
        if (this.has(Keys.RemoveUbiquitousMetadata())) {
            NSNumber val = (NSNumber)this.get(Keys.RemoveUbiquitousMetadata());
            return val.booleanValue();
        }
        return false;
    }

    @Deprecated
    public NSPersistentStoreOptions setShouldRemoveUbiquitousMetadata(boolean shouldRemoveUbiquitousMetadata) {
        this.set(Keys.RemoveUbiquitousMetadata(), NSNumber.valueOf(shouldRemoveUbiquitousMetadata));
        return this;
    }

    @Deprecated
    public String getUbiquitousContainerIdentifier() {
        if (this.has(Keys.UbiquitousContainerIdentifier())) {
            NSString val = (NSString)this.get(Keys.UbiquitousContainerIdentifier());
            return val.toString();
        }
        return null;
    }

    @Deprecated
    public NSPersistentStoreOptions setUbiquitousContainerIdentifier(String ubiquitousContainerIdentifier) {
        this.set(Keys.UbiquitousContainerIdentifier(), new NSString(ubiquitousContainerIdentifier));
        return this;
    }

    @Deprecated
    public boolean shouldRebuildFromUbiquitousContent() {
        if (this.has(Keys.RebuildFromUbiquitousContent())) {
            NSNumber val = (NSNumber)this.get(Keys.RebuildFromUbiquitousContent());
            return val.booleanValue();
        }
        return false;
    }

    @Deprecated
    public NSPersistentStoreOptions setShouldRebuildFromUbiquitousContent(boolean shouldRebuildFromUbiquitousContent) {
        this.set(Keys.RebuildFromUbiquitousContent(), NSNumber.valueOf(shouldRebuildFromUbiquitousContent));
        return this;
    }

    @Library(value="CoreData")
    public static class Keys {
        @GlobalValue(symbol="NSReadOnlyPersistentStoreOption", optional=true)
        public static native NSString ReadOnly();

        @GlobalValue(symbol="NSPersistentStoreTimeoutOption", optional=true)
        public static native NSString Timeout();

        @GlobalValue(symbol="NSSQLitePragmasOption", optional=true)
        public static native NSString SQLitePragmas();

        @GlobalValue(symbol="NSSQLiteAnalyzeOption", optional=true)
        public static native NSString SQLiteAnalyze();

        @GlobalValue(symbol="NSSQLiteManualVacuumOption", optional=true)
        public static native NSString SQLiteManualVacuum();

        @GlobalValue(symbol="NSIgnorePersistentStoreVersioningOption", optional=true)
        public static native NSString IgnorePersistentStoreVersioning();

        @GlobalValue(symbol="NSMigratePersistentStoresAutomaticallyOption", optional=true)
        public static native NSString MigratePersistentStoresAutomatically();

        @GlobalValue(symbol="NSInferMappingModelAutomaticallyOption", optional=true)
        public static native NSString InferMappingModelAutomatically();

        @GlobalValue(symbol="NSPersistentStoreConnectionPoolMaxSizeKey", optional=true)
        public static native NSString ConnectionPoolMaxSize();

        @GlobalValue(symbol="NSPersistentStoreForceDestroyOption", optional=true)
        public static native NSString ForceDestroy();

        @GlobalValue(symbol="NSPersistentStoreFileProtectionKey", optional=true)
        public static native NSString FileProtection();

        @GlobalValue(symbol="NSPersistentHistoryTrackingKey", optional=true)
        public static native NSString HistoryTrackingKey();

        @GlobalValue(symbol="NSBinaryStoreSecureDecodingClasses", optional=true)
        public static native NSString SecureDecodingClasses();

        @GlobalValue(symbol="NSBinaryStoreInsecureDecodingCompatibilityOption", optional=true)
        public static native String InsecureDecodingCompatibilityOption();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreUbiquitousContentNameKey", optional=true)
        public static native NSString UbiquitousContentName();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreUbiquitousContentURLKey", optional=true)
        public static native NSString UbiquitousContentURL();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreUbiquitousPeerTokenOption", optional=true)
        public static native NSString UbiquitousPeerToken();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreRemoveUbiquitousMetadataOption", optional=true)
        public static native NSString RemoveUbiquitousMetadata();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreUbiquitousContainerIdentifierKey", optional=true)
        public static native NSString UbiquitousContainerIdentifier();

        @Deprecated
        @GlobalValue(symbol="NSPersistentStoreRebuildFromUbiquitousContentOption", optional=true)
        public static native NSString RebuildFromUbiquitousContent();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSPersistentStoreOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSPersistentStoreOptions> list = new ArrayList<NSPersistentStoreOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSPersistentStoreOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSPersistentStoreOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSPersistentStoreOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSPersistentStoreOptions toObject(Class<NSPersistentStoreOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSPersistentStoreOptions(o);
        }

        @MarshalsPointer
        public static long toNative(NSPersistentStoreOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

