/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.List;
import org.robovm.apple.coredata.NSFetchRequest;
import org.robovm.apple.coredata.NSFetchRequestResult;
import org.robovm.apple.coredata.NSFetchedResultsControllerDelegate;
import org.robovm.apple.coredata.NSFetchedResultsSectionInfo;
import org.robovm.apple.coredata.NSManagedObject;
import org.robovm.apple.coredata.NSManagedObjectContext;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSIndexPath;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSFetchedResultsController
extends NSObject {
    public NSFetchedResultsController() {
    }

    protected NSFetchedResultsController(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSFetchedResultsController(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithFetchRequest:managedObjectContext:sectionNameKeyPath:cacheName:")
    public NSFetchedResultsController(NSFetchRequest fetchRequest, NSManagedObjectContext context, String sectionNameKeyPath, String name) {
        super(null);
        this.initObject(this.init(fetchRequest, context, sectionNameKeyPath, name));
    }

    @Property(selector="fetchRequest")
    public native NSFetchRequest getFetchRequest();

    @Property(selector="managedObjectContext")
    public native NSManagedObjectContext getManagedObjectContext();

    @Property(selector="sectionNameKeyPath")
    public native String getSectionNameKeyPath();

    @Property(selector="cacheName")
    public native String getCacheName();

    @Property(selector="delegate")
    public native NSFetchedResultsControllerDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(NSFetchedResultsControllerDelegate var1);

    @Property(selector="fetchedObjects")
    public native NSArray<NSManagedObject> getFetchedObjects();

    @Property(selector="sectionIndexTitles")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getSectionIndexTitles();

    @Property(selector="sections")
    @Marshaler(value=NSArray.AsListMarshaler.class)
    public native List<NSFetchedResultsSectionInfo> getSections();

    @Method(selector="initWithFetchRequest:managedObjectContext:sectionNameKeyPath:cacheName:")
    @Pointer
    protected native long init(NSFetchRequest var1, NSManagedObjectContext var2, String var3, String var4);

    public boolean performFetch() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.performFetch(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="performFetch:")
    private native boolean performFetch(NSError.NSErrorPtr var1);

    @Method(selector="objectAtIndexPath:")
    public native NSFetchRequestResult getObjectAtIndexPath(NSIndexPath var1);

    @Method(selector="indexPathForObject:")
    public native NSIndexPath getIndexPathForObject(NSFetchRequestResult var1);

    @Method(selector="sectionIndexTitleForSectionName:")
    public native String getSectionIndexTitleForSectionName(String var1);

    @Method(selector="sectionForSectionIndexTitle:atIndex:")
    @MachineSizedSInt
    public native long getSectionForIndexTitle(String var1, @MachineSizedSInt long var2);

    @Method(selector="deleteCacheWithName:")
    public static native void deleteCache(String var0);

    static {
        ObjCRuntime.bind(NSFetchedResultsController.class);
    }

    public static class NSFetchedResultsControllerPtr
    extends Ptr<NSFetchedResultsController, NSFetchedResultsControllerPtr> {
    }
}

