/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreBluetooth")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CBConnectPeripheralOptions
extends NSDictionaryWrapper {
    CBConnectPeripheralOptions(NSDictionary data) {
        super(data);
    }

    public CBConnectPeripheralOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CBConnectPeripheralOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean notifiesOnConnection() {
        if (this.has(Keys.NotifyOnConnection())) {
            NSNumber val = (NSNumber)this.get(Keys.NotifyOnConnection());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifiesOnConnection(boolean notifiesOnConnection) {
        this.set(Keys.NotifyOnConnection(), NSNumber.valueOf(notifiesOnConnection));
        return this;
    }

    public boolean notifiesOnDisconnection() {
        if (this.has(Keys.NotifyOnDisconnection())) {
            NSNumber val = (NSNumber)this.get(Keys.NotifyOnDisconnection());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifiesOnDisconnection(boolean notifiesOnDisconnection) {
        this.set(Keys.NotifyOnDisconnection(), NSNumber.valueOf(notifiesOnDisconnection));
        return this;
    }

    public boolean notifiesOnNotification() {
        if (this.has(Keys.NotifyOnNotification())) {
            NSNumber val = (NSNumber)this.get(Keys.NotifyOnNotification());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifiesOnNotification(boolean notifiesOnNotification) {
        this.set(Keys.NotifyOnNotification(), NSNumber.valueOf(notifiesOnNotification));
        return this;
    }

    @Library(value="CoreBluetooth")
    public static class Keys {
        @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnConnectionKey", optional=true)
        public static native NSString NotifyOnConnection();

        @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnDisconnectionKey", optional=true)
        public static native NSString NotifyOnDisconnection();

        @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnNotificationKey", optional=true)
        public static native NSString NotifyOnNotification();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CBConnectPeripheralOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CBConnectPeripheralOptions> list = new ArrayList<CBConnectPeripheralOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CBConnectPeripheralOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CBConnectPeripheralOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CBConnectPeripheralOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBConnectPeripheralOptions toObject(Class<CBConnectPeripheralOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBConnectPeripheralOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CBConnectPeripheralOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

