/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corebluetooth.CBCentralManagerScanOptions;
import org.robovm.apple.corebluetooth.CBPeripheral;
import org.robovm.apple.corebluetooth.CBUUID;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreBluetooth")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CBCentralManagerRestoredState
extends NSDictionaryWrapper {
    CBCentralManagerRestoredState(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public NSArray<CBPeripheral> getPeripherals() {
        if (this.has(Keys.Peripherals())) {
            NSArray val = (NSArray)this.get(Keys.Peripherals());
            return val;
        }
        return null;
    }

    public NSArray<CBUUID> getScanServices() {
        if (this.has(Keys.ScanServices())) {
            NSArray val = (NSArray)this.get(Keys.ScanServices());
            return val;
        }
        return null;
    }

    public CBCentralManagerScanOptions getScanOptions() {
        if (this.has(Keys.ScanOptions())) {
            NSDictionary val = (NSDictionary)this.get(Keys.ScanOptions());
            return new CBCentralManagerScanOptions(val);
        }
        return null;
    }

    @Library(value="CoreBluetooth")
    public static class Keys {
        @GlobalValue(symbol="CBCentralManagerRestoredStatePeripheralsKey", optional=true)
        public static native NSString Peripherals();

        @GlobalValue(symbol="CBCentralManagerRestoredStateScanServicesKey", optional=true)
        public static native NSString ScanServices();

        @GlobalValue(symbol="CBCentralManagerRestoredStateScanOptionsKey", optional=true)
        public static native NSString ScanOptions();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CBCentralManagerRestoredState> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CBCentralManagerRestoredState> list = new ArrayList<CBCentralManagerRestoredState>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CBCentralManagerRestoredState((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CBCentralManagerRestoredState> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CBCentralManagerRestoredState i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBCentralManagerRestoredState toObject(Class<CBCentralManagerRestoredState> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBCentralManagerRestoredState(o);
        }

        @MarshalsPointer
        public static long toNative(CBCentralManagerRestoredState o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

