/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreanimation;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="QuartzCore")
@NativeClass
public class CADisplayLink
extends NSObject {
    private static final LongMap<ListenerWrapper> listeners = new LongMap();
    private static final Selector handleUpdate = Selector.register((String)"handleUpdate");

    protected CADisplayLink(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CADisplayLink(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public CADisplayLink(NSObject target, Selector sel) {
        super(null, CADisplayLink.create(target, sel));
        CADisplayLink.retain(this.getHandle());
    }

    public CADisplayLink(OnUpdateListener listener) {
        super(CADisplayLink.create(listener));
        CADisplayLink.retain(this.getHandle());
    }

    private static long create(OnUpdateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ListenerWrapper l = new ListenerWrapper(listener);
        long result = CADisplayLink.create(l, handleUpdate);
        listeners.put(result, (Object)l);
        return result;
    }

    @Property(selector="timestamp")
    public native double getTimestamp();

    @Property(selector="duration")
    public native double getDuration();

    @Property(selector="targetTimestamp")
    public native double getTargetTimestamp();

    @Property(selector="isPaused")
    public native boolean isPaused();

    @Property(selector="setPaused:")
    public native void setPaused(boolean var1);

    @Deprecated
    @Property(selector="frameInterval")
    @MachineSizedSInt
    public native long getFrameInterval();

    @Deprecated
    @Property(selector="setFrameInterval:")
    public native void setFrameInterval(@MachineSizedSInt long var1);

    @Property(selector="preferredFramesPerSecond")
    @MachineSizedSInt
    public native long getPreferredFramesPerSecond();

    @Property(selector="setPreferredFramesPerSecond:")
    public native void setPreferredFramesPerSecond(@MachineSizedSInt long var1);

    public void addToRunLoop(NSRunLoop runloop, NSRunLoopMode mode) {
        this.addToRunLoop(runloop, ((NSString)mode.value()).toString());
    }

    public void removeFromRunLoop(NSRunLoop runloop, NSRunLoopMode mode) {
        this.removeFromRunLoop(runloop, ((NSString)mode.value()).toString());
    }

    protected void dispose(boolean finalizing) {
        listeners.remove(this.getHandle());
        super.dispose(finalizing);
    }

    @Method(selector="addToRunLoop:forMode:")
    public native void addToRunLoop(NSRunLoop var1, String var2);

    @Method(selector="removeFromRunLoop:forMode:")
    public native void removeFromRunLoop(NSRunLoop var1, String var2);

    @Method(selector="invalidate")
    public native void invalidate();

    @Method(selector="displayLinkWithTarget:selector:")
    @Pointer
    protected static native long create(NSObject var0, Selector var1);

    static {
        ObjCRuntime.bind(CADisplayLink.class);
    }

    public static class CADisplayLinkPtr
    extends Ptr<CADisplayLink, CADisplayLinkPtr> {
    }

    private static class ListenerWrapper
    extends NSObject {
        private final OnUpdateListener listener;

        private ListenerWrapper(OnUpdateListener listener) {
            this.listener = listener;
        }

        @Method(selector="handleUpdate")
        private void handleUpdate(CADisplayLink displayLink) {
            this.listener.onUpdate(displayLink);
        }
    }

    public static interface OnUpdateListener {
        public void onUpdate(CADisplayLink var1);
    }
}

