/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.cloudkit;

import java.util.List;
import org.robovm.apple.cloudkit.CKAsset;
import org.robovm.apple.cloudkit.CKRecordID;
import org.robovm.apple.cloudkit.CKRecordZoneID;
import org.robovm.apple.cloudkit.CKReference;
import org.robovm.apple.corelocation.CLLocation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CloudKit")
@NativeClass
public class CKRecord
extends NSObject
implements NSSecureCoding {
    protected CKRecord() {
    }

    protected CKRecord(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CKRecord(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithRecordType:")
    public CKRecord(String recordType) {
        super(null);
        this.initObject(this.init(recordType));
    }

    @Method(selector="initWithRecordType:recordID:")
    public CKRecord(String recordType, CKRecordID recordID) {
        super(null);
        this.initObject(this.init(recordType, recordID));
    }

    @Method(selector="initWithRecordType:zoneID:")
    public CKRecord(String recordType, CKRecordZoneID zoneID) {
        super(null);
        this.initObject(this.init(recordType, zoneID));
    }

    @Method(selector="initWithCoder:")
    public CKRecord(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    @Property(selector="recordType")
    public native String getRecordType();

    @Property(selector="recordID")
    public native CKRecordID getRecordID();

    @Property(selector="recordChangeTag")
    public native String getRecordChangeTag();

    @Property(selector="creatorUserRecordID")
    public native CKRecordID getCreatorUserRecordID();

    @Property(selector="creationDate")
    public native NSDate getCreationDate();

    @Property(selector="lastModifiedUserRecordID")
    public native CKRecordID getLastModifiedUserRecordID();

    @Property(selector="modificationDate")
    public native NSDate getModificationDate();

    @Property(selector="share")
    public native CKReference getShare();

    @Property(selector="parent")
    public native CKReference getParent();

    @Property(selector="setParent:")
    public native void setParent(CKReference var1);

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public void put(String key, String object) {
        this.put(key, new NSString(object));
    }

    public void put(String key, NSString object) {
        this.put(object, key);
    }

    public void put(String key, Number object) {
        this.put(key, NSNumber.valueOf(object));
    }

    public void put(String key, NSNumber object) {
        this.put(object, key);
    }

    public void put(String key, NSData object) {
        this.put(object, key);
    }

    public void put(String key, NSDate object) {
        this.put(object, key);
    }

    @WeaklyLinked
    public void put(String key, CLLocation object) {
        this.put(object, key);
    }

    public void put(String key, CKAsset object) {
        this.put(object, key);
    }

    public void put(String key, CKReference object) {
        this.put(object, key);
    }

    public void put(String key, NSArray<?> object) {
        this.put(object, key);
    }

    public void put(String key, List<String> object) {
        this.put(NSArray.fromStrings(object), key);
    }

    @GlobalValue(symbol="CKRecordParentKey", optional=true)
    public static native String ParentKey();

    @GlobalValue(symbol="CKRecordShareKey", optional=true)
    public static native String ShareKey();

    @Method(selector="initWithRecordType:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="initWithRecordType:recordID:")
    @Pointer
    protected native long init(String var1, CKRecordID var2);

    @Method(selector="initWithRecordType:zoneID:")
    @Pointer
    protected native long init(String var1, CKRecordZoneID var2);

    @Method(selector="objectForKey:")
    public native NSObject get(String var1);

    @Method(selector="setObject:forKey:")
    protected native void put(NSObject var1, String var2);

    @Method(selector="allKeys")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getAllKeys();

    @Method(selector="allTokens")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getAllTokens();

    @Method(selector="changedKeys")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getChangedKeys();

    @Method(selector="encodeSystemFieldsWithCoder:")
    public native void encodeSystemFields(NSCoder var1);

    @Method(selector="setParentReferenceFromRecord:")
    public native void setParentReferenceFromRecord(CKRecord var1);

    @Method(selector="setParentReferenceFromRecordID:")
    public native void setParentReferenceFromRecordID(CKRecordID var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(CKRecord.class);
    }

    public static class CKRecordPtr
    extends Ptr<CKRecord, CKRecordPtr> {
    }
}

