/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVVideoCompressionSettings
extends NSDictionaryWrapper {
    AVVideoCompressionSettings(NSDictionary data) {
        super(data);
    }

    public AVVideoCompressionSettings() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVVideoCompressionSettings set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public double getAverageBitRate() {
        if (this.has(Keys.AverageBitRate())) {
            NSNumber val = (NSNumber)this.get(Keys.AverageBitRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setAverageBitRate(double averageBitRate) {
        this.set(Keys.AverageBitRate(), NSNumber.valueOf(averageBitRate));
        return this;
    }

    public double getQuality() {
        if (this.has(Keys.Quality())) {
            NSNumber val = (NSNumber)this.get(Keys.Quality());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setQuality(double quality) {
        this.set(Keys.Quality(), NSNumber.valueOf(quality));
        return this;
    }

    public double getMaxKeyFrameInterval() {
        if (this.has(Keys.MaxKeyFrameInterval())) {
            NSNumber val = (NSNumber)this.get(Keys.MaxKeyFrameInterval());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setMaxKeyFrameInterval(double maxKeyFrameInterval) {
        this.set(Keys.MaxKeyFrameInterval(), NSNumber.valueOf(maxKeyFrameInterval));
        return this;
    }

    public double getMaxKeyFrameIntervalDuration() {
        if (this.has(Keys.MaxKeyFrameIntervalDuration())) {
            NSNumber val = (NSNumber)this.get(Keys.MaxKeyFrameIntervalDuration());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setMaxKeyFrameIntervalDuration(double maxKeyFrameIntervalDuration) {
        this.set(Keys.MaxKeyFrameIntervalDuration(), NSNumber.valueOf(maxKeyFrameIntervalDuration));
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVVideoAverageBitRateKey", optional=true)
        public static native NSString AverageBitRate();

        @GlobalValue(symbol="AVVideoQualityKey", optional=true)
        public static native NSString Quality();

        @GlobalValue(symbol="AVVideoMaxKeyFrameIntervalKey", optional=true)
        public static native NSString MaxKeyFrameInterval();

        @GlobalValue(symbol="AVVideoMaxKeyFrameIntervalDurationKey", optional=true)
        public static native NSString MaxKeyFrameIntervalDuration();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVVideoCompressionSettings> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVVideoCompressionSettings> list = new ArrayList<AVVideoCompressionSettings>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVVideoCompressionSettings((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVVideoCompressionSettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVVideoCompressionSettings i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVVideoCompressionSettings toObject(Class<AVVideoCompressionSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVVideoCompressionSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVVideoCompressionSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

