/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVPixelAspectRatio;
import org.robovm.apple.avfoundation.AVVideoCleanAperture;
import org.robovm.apple.avfoundation.AVVideoScalingMode;
import org.robovm.apple.avfoundation.AVVideoSettings;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corevideo.CVPixelBufferAttributes;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;

@Library(value="AVFoundation")
public class AVPixelBufferAttributes
extends CVPixelBufferAttributes {
    protected AVPixelBufferAttributes(CFDictionary data) {
        this.data = data;
    }

    public AVPixelBufferAttributes() {
        this.data = CFMutableDictionary.create();
    }

    public AVPixelAspectRatio getPixelAspectRatio() {
        if (this.data.containsKey((NativeObject)AVVideoSettings.Keys.PixelAspectRatio())) {
            NSDictionary val = this.data.get((NativeObject)AVVideoSettings.Keys.PixelAspectRatio(), NSDictionary.class);
            AVPixelAspectRatio result = new AVPixelAspectRatio(val.getLong(AVPixelAspectRatio.HorizontalSpacing(), 0L), val.getLong(AVPixelAspectRatio.VerticalSpacing(), 0L));
            return result;
        }
        return null;
    }

    public AVPixelBufferAttributes setPixelAspectRatio(AVPixelAspectRatio pixelAspectRatio) {
        NSMutableDictionary val = new NSMutableDictionary();
        ((NSDictionary)val).put((Object)AVPixelAspectRatio.HorizontalSpacing(), pixelAspectRatio.getHorizontalSpacing());
        ((NSDictionary)val).put((Object)AVPixelAspectRatio.VerticalSpacing(), pixelAspectRatio.getVerticalSpacing());
        this.data.put((NativeObject)AVVideoSettings.Keys.PixelAspectRatio(), (NativeObject)val);
        return this;
    }

    public AVVideoCleanAperture getCleanAperture() {
        if (this.data.containsKey((NativeObject)AVVideoSettings.Keys.CleanAperture())) {
            NSDictionary val = this.data.get((NativeObject)AVVideoSettings.Keys.CleanAperture(), NSDictionary.class);
            return new AVVideoCleanAperture(val);
        }
        return null;
    }

    public AVPixelBufferAttributes setCleanAperture(AVVideoCleanAperture cleanAperture) {
        this.data.put((NativeObject)AVVideoSettings.Keys.CleanAperture(), (NativeObject)cleanAperture.getDictionary());
        return this;
    }

    public AVVideoScalingMode getScalingMode() {
        if (this.data.containsKey((NativeObject)AVVideoSettings.Keys.ScalingMode())) {
            NSString val = this.data.get((NativeObject)AVVideoSettings.Keys.ScalingMode(), NSString.class);
            return AVVideoScalingMode.valueOf(val);
        }
        return null;
    }

    public AVPixelBufferAttributes setScalingMode(AVVideoScalingMode scalingMode) {
        this.data.put((NativeObject)AVVideoSettings.Keys.ScalingMode(), (NativeObject)scalingMode.value());
        return this;
    }

    static {
        Bro.bind(AVPixelBufferAttributes.class);
    }
}

