/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioEngine;
import org.robovm.apple.avfoundation.AVMusicSequenceLoadOptions;
import org.robovm.apple.avfoundation.AVMusicTrack;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioSequencer
extends NSObject {
    public AVAudioSequencer() {
    }

    protected AVAudioSequencer(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioSequencer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithAudioEngine:")
    public AVAudioSequencer(AVAudioEngine engine) {
        super(null);
        this.initObject(this.init(engine));
    }

    @Property(selector="tracks")
    public native NSArray<AVMusicTrack> getTracks();

    @Property(selector="tempoTrack")
    public native AVMusicTrack getTempoTrack();

    @Property(selector="userInfo")
    public native NSDictionary<NSString, ?> getUserInfo();

    @Property(selector="currentPositionInSeconds")
    public native double getCurrentPositionInSeconds();

    @Property(selector="setCurrentPositionInSeconds:")
    public native void setCurrentPositionInSeconds(double var1);

    @Property(selector="currentPositionInBeats")
    public native double getCurrentPositionInBeats();

    @Property(selector="setCurrentPositionInBeats:")
    public native void setCurrentPositionInBeats(double var1);

    @Property(selector="isPlaying")
    public native boolean isPlaying();

    @Property(selector="rate")
    public native float getRate();

    @Property(selector="setRate:")
    public native void setRate(float var1);

    @Method(selector="initWithAudioEngine:")
    @Pointer
    protected native long init(AVAudioEngine var1);

    public boolean load(NSURL fileURL, AVMusicSequenceLoadOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.load(fileURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadFromURL:options:error:")
    private native boolean load(NSURL var1, AVMusicSequenceLoadOptions var2, NSError.NSErrorPtr var3);

    public boolean load(NSData data, AVMusicSequenceLoadOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.load(data, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadFromData:options:error:")
    private native boolean load(NSData var1, AVMusicSequenceLoadOptions var2, NSError.NSErrorPtr var3);

    public boolean write(NSURL fileURL, @MachineSizedSInt long resolution, boolean replace) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.write(fileURL, resolution, replace, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToURL:SMPTEResolution:replaceExisting:error:")
    private native boolean write(NSURL var1, @MachineSizedSInt long var2, boolean var4, NSError.NSErrorPtr var5);

    public NSData getData(@MachineSizedSInt long SMPTEResolution) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.getData(SMPTEResolution, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dataWithSMPTEResolution:error:")
    private native NSData getData(@MachineSizedSInt long var1, NSError.NSErrorPtr var3);

    @Method(selector="secondsForBeats:")
    public native double convertBeatsToSeconds(double var1);

    @Method(selector="beatsForSeconds:")
    public native double convertSecondsToBeats(double var1);

    public long convertBeatsToHostTime(double beats) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long result = this.convertBeatsToHostTime(beats, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="hostTimeForBeats:error:")
    private native long convertBeatsToHostTime(double var1, NSError.NSErrorPtr var3);

    public double convertHostTimeToBeats(long hostTime) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        double result = this.convertHostTimeToBeats(hostTime, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="beatsForHostTime:error:")
    private native double convertHostTimeToBeats(long var1, NSError.NSErrorPtr var3);

    @Method(selector="prepareToPlay")
    public native void prepareToPlay();

    public boolean start() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.start(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="startAndReturnError:")
    private native boolean start(NSError.NSErrorPtr var1);

    @Method(selector="stop")
    public native void stop();

    static {
        ObjCRuntime.bind(AVAudioSequencer.class);
    }

    public static class AVAudioSequencerPtr
    extends Ptr<AVAudioSequencer, AVAudioSequencerPtr> {
    }
}

