/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.avfoundation.AVAudioPlayerDelegate;
import org.robovm.apple.avfoundation.AVAudioSessionChannelDescription;
import org.robovm.apple.avfoundation.AVAudioSettings;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioPlayer
extends NSObject {
    public AVAudioPlayer() {
    }

    protected AVAudioPlayer(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioPlayer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithContentsOfURL:error:")
    public AVAudioPlayer(NSURL url) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initWithData:error:")
    public AVAudioPlayer(NSData data) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initWithContentsOfURL:fileTypeHint:error:")
    public AVAudioPlayer(NSURL url, String utiString) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(url, utiString, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initWithData:fileTypeHint:error:")
    public AVAudioPlayer(NSData data, String utiString) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(data, utiString, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Property(selector="isPlaying")
    public native boolean isPlaying();

    @Property(selector="numberOfChannels")
    @MachineSizedUInt
    public native long getNumberOfChannels();

    @Property(selector="duration")
    public native double getDuration();

    @Property(selector="delegate")
    public native AVAudioPlayerDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(AVAudioPlayerDelegate var1);

    @Property(selector="url")
    public native NSURL getUrl();

    @Property(selector="data")
    public native NSData getData();

    @Property(selector="pan")
    public native float getPan();

    @Property(selector="setPan:")
    public native void setPan(float var1);

    @Property(selector="volume")
    public native float getVolume();

    @Property(selector="setVolume:")
    public native void setVolume(float var1);

    @Property(selector="enableRate")
    public native boolean isRateEnabled();

    @Property(selector="setEnableRate:")
    public native void setRateEnabled(boolean var1);

    @Property(selector="rate")
    public native float getRate();

    @Property(selector="setRate:")
    public native void setRate(float var1);

    @Property(selector="currentTime")
    public native double getCurrentTime();

    @Property(selector="setCurrentTime:")
    public native void setCurrentTime(double var1);

    @Property(selector="deviceCurrentTime")
    public native double getDeviceCurrentTime();

    @Property(selector="numberOfLoops")
    @MachineSizedSInt
    public native long getNumberOfLoops();

    @Property(selector="setNumberOfLoops:")
    public native void setNumberOfLoops(@MachineSizedSInt long var1);

    @Property(selector="settings")
    public native AVAudioSettings getSettings();

    @Property(selector="format")
    public native AVAudioFormat getFormat();

    @Property(selector="isMeteringEnabled")
    public native boolean isMeteringEnabled();

    @Property(selector="setMeteringEnabled:")
    public native void setMeteringEnabled(boolean var1);

    @Property(selector="channelAssignments")
    public native NSArray<AVAudioSessionChannelDescription> getChannelAssignments();

    @Property(selector="setChannelAssignments:")
    public native void setChannelAssignments(NSArray<AVAudioSessionChannelDescription> var1);

    @Method(selector="initWithContentsOfURL:error:")
    @Pointer
    private native long init(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="initWithData:error:")
    @Pointer
    private native long init(NSData var1, NSError.NSErrorPtr var2);

    @Method(selector="initWithContentsOfURL:fileTypeHint:error:")
    @Pointer
    private native long init(NSURL var1, String var2, NSError.NSErrorPtr var3);

    @Method(selector="initWithData:fileTypeHint:error:")
    @Pointer
    private native long init(NSData var1, String var2, NSError.NSErrorPtr var3);

    @Method(selector="prepareToPlay")
    public native boolean prepareToPlay();

    @Method(selector="play")
    public native boolean play();

    @Method(selector="playAtTime:")
    public native boolean playAtTime(double var1);

    @Method(selector="pause")
    public native void pause();

    @Method(selector="stop")
    public native void stop();

    @Method(selector="setVolume:fadeDuration:")
    public native void setVolume(float var1, double var2);

    @Method(selector="updateMeters")
    public native void updateMeters();

    @Method(selector="peakPowerForChannel:")
    public native float getPeakPowerForChannel(@MachineSizedUInt long var1);

    @Method(selector="averagePowerForChannel:")
    public native float getAveragePowerForChannel(@MachineSizedUInt long var1);

    static {
        ObjCRuntime.bind(AVAudioPlayer.class);
    }

    public static class AVAudioPlayerPtr
    extends Ptr<AVAudioPlayer, AVAudioPlayerPtr> {
    }
}

