/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.audiotoolbox.MusicSequence;
import org.robovm.apple.avfoundation.AVAudioConnectionPoint;
import org.robovm.apple.avfoundation.AVAudioEngineManualRenderingMode;
import org.robovm.apple.avfoundation.AVAudioEngineManualRenderingStatus;
import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.avfoundation.AVAudioInputNode;
import org.robovm.apple.avfoundation.AVAudioMixerNode;
import org.robovm.apple.avfoundation.AVAudioNode;
import org.robovm.apple.avfoundation.AVAudioOutputNode;
import org.robovm.apple.avfoundation.AVAudioPCMBuffer;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block3;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioEngine
extends NSObject {
    public AVAudioEngine() {
    }

    protected AVAudioEngine(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioEngine(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="musicSequence")
    @WeaklyLinked
    public native MusicSequence getMusicSequence();

    @Property(selector="setMusicSequence:")
    @WeaklyLinked
    public native void setMusicSequence(MusicSequence var1);

    @Property(selector="outputNode")
    public native AVAudioOutputNode getOutputNode();

    @Property(selector="inputNode")
    public native AVAudioInputNode getInputNode();

    @Property(selector="mainMixerNode")
    public native AVAudioMixerNode getMainMixerNode();

    @Property(selector="isRunning")
    public native boolean isRunning();

    @Property(selector="isAutoShutdownEnabled")
    public native boolean isAutoShutdownEnabled();

    @Property(selector="setAutoShutdownEnabled:")
    public native void setAutoShutdownEnabled(boolean var1);

    @Property(selector="manualRenderingBlock")
    @Block
    public native Block3<Integer, AudioBufferList, OSStatus.OSStatusPtr, AVAudioEngineManualRenderingStatus> getManualRenderingBlock();

    @Property(selector="isInManualRenderingMode")
    public native boolean isInManualRenderingMode();

    @Property(selector="manualRenderingMode")
    public native AVAudioEngineManualRenderingMode getManualRenderingMode();

    @Property(selector="manualRenderingFormat")
    public native AVAudioFormat getManualRenderingFormat();

    @Property(selector="manualRenderingMaximumFrameCount")
    public native int getManualRenderingMaximumFrameCount();

    @Property(selector="manualRenderingSampleTime")
    public native long getManualRenderingSampleTime();

    @GlobalValue(symbol="AVAudioEngineConfigurationChangeNotification", optional=true)
    public static native NSString ConfigurationChangeNotification();

    @Method(selector="attachNode:")
    public native void attachNode(AVAudioNode var1);

    @Method(selector="detachNode:")
    public native void detachNode(AVAudioNode var1);

    @Method(selector="connect:to:fromBus:toBus:format:")
    public native void connect(AVAudioNode var1, AVAudioNode var2, @MachineSizedUInt long var3, @MachineSizedUInt long var5, AVAudioFormat var7);

    @Method(selector="connect:to:format:")
    public native void connect(AVAudioNode var1, AVAudioNode var2, AVAudioFormat var3);

    @Method(selector="connect:toConnectionPoints:fromBus:format:")
    public native void connect(AVAudioNode var1, NSArray<AVAudioConnectionPoint> var2, @MachineSizedUInt long var3, AVAudioFormat var5);

    @Method(selector="disconnectNodeInput:bus:")
    public native void disconnectNodeInput(AVAudioNode var1, @MachineSizedUInt long var2);

    @Method(selector="disconnectNodeInput:")
    public native void disconnectNodeInput(AVAudioNode var1);

    @Method(selector="disconnectNodeOutput:bus:")
    public native void disconnectNodeOutput(AVAudioNode var1, @MachineSizedUInt long var2);

    @Method(selector="disconnectNodeOutput:")
    public native void disconnectNodeOutput(AVAudioNode var1);

    @Method(selector="prepare")
    public native void prepare();

    public boolean start() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.start(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="startAndReturnError:")
    private native boolean start(NSError.NSErrorPtr var1);

    @Method(selector="pause")
    public native void pause();

    @Method(selector="reset")
    public native void reset();

    @Method(selector="stop")
    public native void stop();

    @Method(selector="inputConnectionPointForNode:inputBus:")
    public native AVAudioConnectionPoint getInputConnectionPoint(AVAudioNode var1, @MachineSizedUInt long var2);

    @Method(selector="outputConnectionPointsForNode:outputBus:")
    public native NSArray<AVAudioConnectionPoint> getOutputConnectionPoints(AVAudioNode var1, @MachineSizedUInt long var2);

    public boolean enableManualRenderingMode(AVAudioEngineManualRenderingMode mode, AVAudioFormat pcmFormat, int maximumFrameCount) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.enableManualRenderingMode(mode, pcmFormat, maximumFrameCount, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="enableManualRenderingMode:format:maximumFrameCount:error:")
    private native boolean enableManualRenderingMode(AVAudioEngineManualRenderingMode var1, AVAudioFormat var2, int var3, NSError.NSErrorPtr var4);

    @Method(selector="disableManualRenderingMode")
    public native void disableManualRenderingMode();

    public AVAudioEngineManualRenderingStatus renderOffline(int numberOfFrames, AVAudioPCMBuffer buffer) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        AVAudioEngineManualRenderingStatus result = this.renderOffline(numberOfFrames, buffer, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="renderOffline:toBuffer:error:")
    private native AVAudioEngineManualRenderingStatus renderOffline(int var1, AVAudioPCMBuffer var2, NSError.NSErrorPtr var3);

    static {
        ObjCRuntime.bind(AVAudioEngine.class);
    }

    public static class AVAudioEnginePtr
    extends Ptr<AVAudioEngine, AVAudioEnginePtr> {
    }

    public static class Notifications {
        public static NSObject observeConfigurationChange(AVAudioEngine object, final VoidBlock1<AVAudioEngine> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioEngine.ConfigurationChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVAudioEngine)a.getObject()));
                }
            });
        }
    }
}

