/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.MusicSequence;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AudioToolbox")
public class MusicPlayer
extends NativeObject {
    protected MusicPlayer() {
    }

    public static MusicPlayer create() throws OSStatusException {
        MusicPlayerPtr ptr = new MusicPlayerPtr();
        OSStatus status = MusicPlayer.create0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicPlayer)ptr.get();
    }

    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        OSStatusException.throwIfNecessary(status);
    }

    public void setSequence(MusicSequence sequence) throws OSStatusException {
        OSStatus status = this.setSequence0(sequence);
        OSStatusException.throwIfNecessary(status);
    }

    public MusicSequence getSequence() throws OSStatusException {
        MusicSequence.MusicSequencePtr ptr = new MusicSequence.MusicSequencePtr();
        OSStatus status = this.getSequence0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicSequence)ptr.get();
    }

    public void setTime(double time) throws OSStatusException {
        OSStatus status = this.setTime0(time);
        OSStatusException.throwIfNecessary(status);
    }

    public double getTime() throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.getTime0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public long getHostTimeForBeats(double beats) throws OSStatusException {
        LongPtr ptr = new LongPtr();
        OSStatus status = this.getHostTimeForBeats0(beats, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public double getBeatsForHostTime(long hostTime) throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.getBeatsForHostTime0(hostTime, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void preroll() throws OSStatusException {
        OSStatus status = this.preroll0();
        OSStatusException.throwIfNecessary(status);
    }

    public void start() throws OSStatusException {
        OSStatus status = this.start0();
        OSStatusException.throwIfNecessary(status);
    }

    public void stop() throws OSStatusException {
        OSStatus status = this.stop0();
        OSStatusException.throwIfNecessary(status);
    }

    public boolean isPlaying() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.isPlaying0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setPlayRateScalar(double scaleRate) throws OSStatusException {
        OSStatus status = this.setPlayRateScalar0(scaleRate);
        OSStatusException.throwIfNecessary(status);
    }

    public double getPlayRateScalar() throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.getPlayRateScalar0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    @Bridge(symbol="NewMusicPlayer", optional=true)
    protected static native OSStatus create0(MusicPlayerPtr var0);

    @Bridge(symbol="DisposeMusicPlayer", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="MusicPlayerSetSequence", optional=true)
    protected native OSStatus setSequence0(MusicSequence var1);

    @Bridge(symbol="MusicPlayerGetSequence", optional=true)
    protected native OSStatus getSequence0(MusicSequence.MusicSequencePtr var1);

    @Bridge(symbol="MusicPlayerSetTime", optional=true)
    protected native OSStatus setTime0(double var1);

    @Bridge(symbol="MusicPlayerGetTime", optional=true)
    protected native OSStatus getTime0(DoublePtr var1);

    @Bridge(symbol="MusicPlayerGetHostTimeForBeats", optional=true)
    protected native OSStatus getHostTimeForBeats0(double var1, LongPtr var3);

    @Bridge(symbol="MusicPlayerGetBeatsForHostTime", optional=true)
    protected native OSStatus getBeatsForHostTime0(long var1, DoublePtr var3);

    @Bridge(symbol="MusicPlayerPreroll", optional=true)
    protected native OSStatus preroll0();

    @Bridge(symbol="MusicPlayerStart", optional=true)
    protected native OSStatus start0();

    @Bridge(symbol="MusicPlayerStop", optional=true)
    protected native OSStatus stop0();

    @Bridge(symbol="MusicPlayerIsPlaying", optional=true)
    protected native OSStatus isPlaying0(BooleanPtr var1);

    @Bridge(symbol="MusicPlayerSetPlayRateScalar", optional=true)
    protected native OSStatus setPlayRateScalar0(double var1);

    @Bridge(symbol="MusicPlayerGetPlayRateScalar", optional=true)
    protected native OSStatus getPlayRateScalar0(DoublePtr var1);

    static {
        Bro.bind(MusicPlayer.class);
    }

    public static class MusicPlayerPtr
    extends Ptr<MusicPlayer, MusicPlayerPtr> {
    }
}

