/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.rt.VM;
import org.robovm.rt.bro.BufferMarshalers;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

public class AudioQueueBuffer
extends Struct<AudioQueueBuffer> {
    public AudioQueueBuffer() {
    }

    public AudioQueueBuffer(long handle) {
        super(handle);
    }

    public AudioQueueBuffer setAudioData(long dataPointer, int length) {
        this.setData0(dataPointer);
        this.setAudioDataByteSize(length);
        return this;
    }

    public AudioQueueBuffer setAudioData(byte[] data) {
        this.setArrayAudioData(data, data.length);
        return this;
    }

    public AudioQueueBuffer setAudioData(short[] data) {
        this.setArrayAudioData(data, data.length);
        return this;
    }

    public AudioQueueBuffer setAudioData(int[] data) {
        this.setArrayAudioData(data, data.length);
        return this;
    }

    public AudioQueueBuffer setAudioData(float[] data) {
        this.setArrayAudioData(data, data.length);
        return this;
    }

    public AudioQueueBuffer setAudioData(Buffer data) {
        this.setAudioDataByteSize(data.capacity());
        this.setData0(BufferMarshalers.BufferMarshaler.toNative((Buffer)data, (long)0L));
        return this;
    }

    private AudioQueueBuffer setArrayAudioData(Object array, int length) {
        this.setAudioDataByteSize(length);
        this.setData0(VM.getArrayValuesAddress((Object)array));
        return this;
    }

    public <T extends Buffer> T getAudioDataAsBuffer(Class<T> bufferType) {
        long dataPointer = this.getDataPointer();
        if (bufferType == ByteBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)this.getAudioDataByteSize());
        }
        if (bufferType == ShortBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getAudioDataByteSize() << 1)).order(ByteOrder.nativeOrder()).asShortBuffer();
        }
        if (bufferType == IntBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getAudioDataByteSize() << 2)).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        if (bufferType == FloatBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getAudioDataByteSize() << 2)).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        throw new UnsupportedOperationException("Buffer type not supported: " + bufferType);
    }

    public byte[] getAudioDataAsByteArray() {
        int length = this.getAudioDataByteSize();
        byte[] data = new byte[length];
        this.getAudioDataAsBuffer(ByteBuffer.class).get(data, 0, length);
        return data;
    }

    public short[] getAudioDataAsShortArray() {
        int length = this.getAudioDataByteSize();
        short[] data = new short[length];
        this.getAudioDataAsBuffer(ShortBuffer.class).get(data, 0, length);
        return data;
    }

    public int[] getAudioDataAsIntArray() {
        int length = this.getAudioDataByteSize();
        int[] data = new int[length];
        this.getAudioDataAsBuffer(IntBuffer.class).get(data, 0, length);
        return data;
    }

    public float[] getAudioDataAsFloatArray() {
        int length = this.getAudioDataByteSize();
        float[] data = new float[length];
        this.getAudioDataAsBuffer(FloatBuffer.class).get(data, 0, length);
        return data;
    }

    public int getPacketDescriptionCount() {
        return this.getPacketDescriptionCount0();
    }

    public AudioStreamPacketDescription getPacketDescription(int index) {
        if (index >= this.getPacketDescriptionCount0()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (AudioStreamPacketDescription)((AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr)this.getPacketDescriptions0().next(index)).get();
    }

    public AudioQueueBuffer setPacketDescription(int index, AudioStreamPacketDescription value) {
        if (index >= this.getPacketDescriptionCount0()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr)this.getPacketDescriptions0().next(index)).set((NativeObject)value);
        return this;
    }

    public AudioStreamPacketDescription[] getPacketDescriptions() {
        int count = this.getPacketDescriptionCount0();
        AudioStreamPacketDescription[] array = new AudioStreamPacketDescription[count];
        AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr ptr = this.getPacketDescriptions0();
        for (int i = 0; i < count; ++i) {
            array[i] = (AudioStreamPacketDescription)((AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr)ptr.next(i)).get();
        }
        return array;
    }

    public AudioQueueBuffer setPacketDescriptions(AudioStreamPacketDescription[] regions) {
        this.setPacketDescriptionCount0(regions.length);
        this.getPacketDescriptions0().set((NativeObject[])regions);
        return this;
    }

    @StructMember(value=2)
    protected native int getAudioDataByteSize();

    @StructMember(value=2)
    protected native AudioQueueBuffer setAudioDataByteSize(int var1);

    @StructMember(value=3)
    protected native VoidPtr getUserData();

    @StructMember(value=3)
    protected native AudioQueueBuffer setUserData(VoidPtr var1);

    @StructMember(value=5)
    protected native AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr getPacketDescriptions0();

    @StructMember(value=5)
    protected native AudioQueueBuffer setPacketDescriptions0(AudioStreamPacketDescription.AudioStreamPacketDescriptionPtr var1);

    @StructMember(value=6)
    protected native int getPacketDescriptionCount0();

    @StructMember(value=6)
    protected native AudioQueueBuffer setPacketDescriptionCount0(int var1);

    @StructMember(value=0)
    public native int getAudioDataBytesCapacity();

    @StructMember(value=4)
    public native int getPacketDescriptionCapacity();

    @StructMember(value=1)
    @Pointer
    public native long getDataPointer();

    @StructMember(value=1)
    protected native AudioQueueBuffer setData0(@Pointer long var1);

    public static class AudioQueueBufferPtr
    extends Ptr<AudioQueueBuffer, AudioQueueBufferPtr> {
    }
}

