/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioFileFlags;
import org.robovm.apple.audiotoolbox.AudioFilePermissions;
import org.robovm.apple.audiotoolbox.AudioFileProperty;
import org.robovm.apple.audiotoolbox.AudioFileType;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.LongMap;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioFile
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static final LongMap<Callbacks> callbacks = new LongMap();
    private static final Method cbRead;
    private static final Method cbWrite;
    private static final Method cbGetSize;
    private static final Method cbSetSize;

    protected AudioFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static final OSStatus cbRead(@Pointer long clientData, long position, int requestCount, @Pointer long buffer, IntPtr actualCount) {
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            try {
                int actualRead = ((Callbacks)callbacks.get(clientData)).read(position, requestCount, VM.newDirectByteBuffer((long)buffer, (long)requestCount));
                actualCount.set(actualRead);
            }
            catch (OSStatusException e) {
                return e.getStatus();
            }
            return OSStatus.NO_ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static final OSStatus cbWrite(@Pointer long clientData, long position, int requestCount, @Pointer long buffer, IntPtr actualCount) {
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            try {
                int actualWrite = ((Callbacks)callbacks.get(clientData)).write(position, requestCount, VM.newDirectByteBuffer((long)buffer, (long)requestCount));
                actualCount.set(actualWrite);
            }
            catch (OSStatusException e) {
                return e.getStatus();
            }
            return OSStatus.NO_ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static final long cbGetSize(@Pointer long clientData) {
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            return ((Callbacks)callbacks.get(clientData)).getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static final OSStatus cbSetSize(@Pointer long clientData, long size) {
        LongMap<Callbacks> longMap = callbacks;
        synchronized (longMap) {
            ((Callbacks)callbacks.get(clientData)).setSize(size);
            return OSStatus.NO_ERR;
        }
    }

    public static AudioFile create(NSURL fileRef, AudioFileType fileType, AudioStreamBasicDescription format, AudioFileFlags flags) throws OSStatusException {
        AudioFilePtr ptr = new AudioFilePtr();
        OSStatus status = AudioFile.create0(fileRef, fileType, format, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioFile)ptr.get();
    }

    public static AudioFile openURL(NSURL fileRef, AudioFilePermissions permissions, AudioFileType fileTypeHint) throws OSStatusException {
        AudioFilePtr ptr = new AudioFilePtr();
        OSStatus status = AudioFile.openURL0(fileRef, permissions, fileTypeHint, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioFile)ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFile initialize(Callbacks callback, AudioFileType fileType, AudioStreamBasicDescription format, AudioFileFlags flags) throws OSStatusException {
        if (callback == null) {
            throw new NullPointerException("callbacks");
        }
        AudioFilePtr ptr = new AudioFilePtr();
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioFile.initialize0(cid, new FunctionPtr(cbRead), new FunctionPtr(cbWrite), new FunctionPtr(cbGetSize), new FunctionPtr(cbSetSize), fileType, format, flags, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<Callbacks> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(cid, (Object)callback);
            }
            return (AudioFile)ptr.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFile open(Callbacks callback, AudioFileType fileTypeHint) throws OSStatusException {
        if (callback == null) {
            throw new NullPointerException("callbacks");
        }
        AudioFilePtr ptr = new AudioFilePtr();
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioFile.open0(cid, new FunctionPtr(cbRead), new FunctionPtr(cbWrite), new FunctionPtr(cbGetSize), new FunctionPtr(cbSetSize), fileTypeHint, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<Callbacks> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(cid, (Object)callback);
            }
            return (AudioFile)ptr.get();
        }
        return null;
    }

    public void closeFile() throws OSStatusException {
        OSStatus status = this.closeFile0();
        OSStatusException.throwIfNecessary(status);
    }

    public void optimize() throws OSStatusException {
        OSStatus status = this.optimize0();
        OSStatusException.throwIfNecessary(status);
    }

    public byte[] readBytes(boolean useCache, long startingByte, int bytesToRead) throws OSStatusException {
        IntPtr numBytesPtr = new IntPtr();
        BytePtr ptr = new BytePtr();
        OSStatus status = this.readBytes0(useCache, startingByte, numBytesPtr, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.toByteArray(numBytesPtr.get());
    }

    public int writeBytes(boolean useCache, long startingByte, byte[] buffer) throws OSStatusException {
        IntPtr ptr = new IntPtr(buffer.length);
        OSStatus status = this.writeBytes0(useCache, startingByte, ptr, VM.getArrayValuesAddress((Object)buffer));
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public int countUserData(int userDataID) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.countUserData0(userDataID, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public int getUserDataSize(int userDataID, int index) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getUserDataSize0(userDataID, index, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getUserData(int userDataID, int index, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getUserData0(userDataID, index, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public void setUserData(int userDataID, int index, Struct<?> userData) throws OSStatusException {
        OSStatus status = this.setUserData0(userDataID, index, userData == null ? 0 : Struct.sizeOf(userData), userData == null ? null : (VoidPtr)userData.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public void removeUserData(int userDataID, int index) throws OSStatusException {
        OSStatus status = this.removeUserData0(userDataID, index);
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertySize(AudioFileProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(id, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isPropertyWritable(AudioFileProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(id, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get() != 0;
    }

    public <T extends Struct<T>> T getProperty(AudioFileProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(AudioFileProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(AudioFileProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(AudioFileProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(AudioFileProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(AudioFileProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(AudioFileProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(AudioFileProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(AudioFileProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(AudioFileProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    public static int getGlobalInfoSize(AudioFileProperty id, Struct<?> specifier) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = AudioFile.getGlobalInfoSize0(id, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public static <T extends Struct<T>> T getGlobalInfo(AudioFileProperty id, Struct<?> specifier, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = AudioFile.getGlobalInfo0(id, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    @Bridge(symbol="AudioFileCreateWithURL", optional=true)
    protected static native OSStatus create0(NSURL var0, AudioFileType var1, AudioStreamBasicDescription var2, AudioFileFlags var3, AudioFilePtr var4);

    @Bridge(symbol="AudioFileOpenURL", optional=true)
    protected static native OSStatus openURL0(NSURL var0, AudioFilePermissions var1, AudioFileType var2, AudioFilePtr var3);

    @Bridge(symbol="AudioFileInitializeWithCallbacks", optional=true)
    protected static native OSStatus initialize0(@Pointer long var0, FunctionPtr var2, FunctionPtr var3, FunctionPtr var4, FunctionPtr var5, AudioFileType var6, AudioStreamBasicDescription var7, AudioFileFlags var8, AudioFilePtr var9);

    @Bridge(symbol="AudioFileOpenWithCallbacks", optional=true)
    protected static native OSStatus open0(@Pointer long var0, FunctionPtr var2, FunctionPtr var3, FunctionPtr var4, FunctionPtr var5, AudioFileType var6, AudioFilePtr var7);

    @Bridge(symbol="AudioFileClose", optional=true)
    protected native OSStatus closeFile0();

    @Bridge(symbol="AudioFileOptimize", optional=true)
    protected native OSStatus optimize0();

    @Bridge(symbol="AudioFileReadBytes", optional=true)
    protected native OSStatus readBytes0(boolean var1, long var2, IntPtr var4, BytePtr var5);

    @Bridge(symbol="AudioFileWriteBytes", optional=true)
    protected native OSStatus writeBytes0(boolean var1, long var2, IntPtr var4, @Pointer long var5);

    @Bridge(symbol="AudioFileReadPacketData", optional=true)
    protected native OSStatus readPacketData0(boolean var1, IntPtr var2, AudioStreamPacketDescription var3, long var4, IntPtr var6, VoidPtr var7);

    @Deprecated
    @Bridge(symbol="AudioFileReadPackets", optional=true)
    protected native OSStatus readPackets0(boolean var1, IntPtr var2, AudioStreamPacketDescription var3, long var4, IntPtr var6, VoidPtr var7);

    @Bridge(symbol="AudioFileWritePackets", optional=true)
    protected native OSStatus writePackets0(boolean var1, int var2, AudioStreamPacketDescription var3, long var4, IntPtr var6, VoidPtr var7);

    @Bridge(symbol="AudioFileCountUserData", optional=true)
    protected native OSStatus countUserData0(int var1, IntPtr var2);

    @Bridge(symbol="AudioFileGetUserDataSize", optional=true)
    protected native OSStatus getUserDataSize0(int var1, int var2, IntPtr var3);

    @Bridge(symbol="AudioFileGetUserData", optional=true)
    protected native OSStatus getUserData0(int var1, int var2, IntPtr var3, VoidPtr var4);

    @Bridge(symbol="AudioFileSetUserData", optional=true)
    protected native OSStatus setUserData0(int var1, int var2, int var3, VoidPtr var4);

    @Bridge(symbol="AudioFileRemoveUserData", optional=true)
    protected native OSStatus removeUserData0(int var1, int var2);

    @Bridge(symbol="AudioFileGetPropertyInfo", optional=true)
    protected native OSStatus getPropertyInfo0(AudioFileProperty var1, IntPtr var2, IntPtr var3);

    @Bridge(symbol="AudioFileGetProperty", optional=true)
    protected native OSStatus getProperty0(AudioFileProperty var1, IntPtr var2, VoidPtr var3);

    @Bridge(symbol="AudioFileSetProperty", optional=true)
    protected native OSStatus setProperty0(AudioFileProperty var1, int var2, VoidPtr var3);

    @Bridge(symbol="AudioFileGetGlobalInfoSize", optional=true)
    protected static native OSStatus getGlobalInfoSize0(AudioFileProperty var0, int var1, VoidPtr var2, IntPtr var3);

    @Bridge(symbol="AudioFileGetGlobalInfo", optional=true)
    protected static native OSStatus getGlobalInfo0(AudioFileProperty var0, int var1, VoidPtr var2, IntPtr var3, VoidPtr var4);

    static {
        try {
            cbRead = AudioFile.class.getDeclaredMethod("cbRead", Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, IntPtr.class);
            cbWrite = AudioFile.class.getDeclaredMethod("cbWrite", Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, IntPtr.class);
            cbGetSize = AudioFile.class.getDeclaredMethod("cbGetSize", Long.TYPE);
            cbSetSize = AudioFile.class.getDeclaredMethod("cbSetSize", Long.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioFile.class);
    }

    public static class AudioFilePtr
    extends Ptr<AudioFile, AudioFilePtr> {
    }

    public static interface Callbacks {
        public int read(long var1, int var3, ByteBuffer var4) throws OSStatusException;

        public int write(long var1, int var3, ByteBuffer var4) throws OSStatusException;

        public long getSize();

        public void setSize(long var1);
    }
}

