/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioComponentDescription;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIImage;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AudioToolbox")
public class AudioComponent
extends NativeObject {
    protected AudioComponent() {
    }

    public String getName() throws OSStatusException {
        CFString.CFStringPtr ptr = new CFString.CFStringPtr();
        OSStatus status = this.getName0(ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            return ((CFString)ptr.get()).toString();
        }
        return null;
    }

    public AudioComponentDescription getDescription() throws OSStatusException {
        AudioComponentDescription.AudioComponentDescriptionPtr ptr = new AudioComponentDescription.AudioComponentDescriptionPtr();
        OSStatus status = this.getDescription0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioComponentDescription)ptr.get();
    }

    public int getVersion() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getVersion0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    @GlobalValue(symbol="kAudioComponentRegistrationsChangedNotification", optional=true)
    public static native NSString RegistrationsChangedNotification();

    @GlobalValue(symbol="kAudioComponentInstanceInvalidationNotification", optional=true)
    public static native NSString InstanceInvalidationNotification();

    @Bridge(symbol="AudioComponentFindNext", optional=true)
    public static native AudioComponent findNext(AudioComponent var0, AudioComponentDescription var1);

    @Bridge(symbol="AudioComponentCount", optional=true)
    public static native int count(AudioComponentDescription var0);

    @Bridge(symbol="AudioComponentCopyName", optional=true)
    protected native OSStatus getName0(CFString.CFStringPtr var1);

    @Bridge(symbol="AudioComponentGetDescription", optional=true)
    protected native OSStatus getDescription0(AudioComponentDescription.AudioComponentDescriptionPtr var1);

    @Bridge(symbol="AudioComponentGetVersion", optional=true)
    protected native OSStatus getVersion0(IntPtr var1);

    @Bridge(symbol="AudioComponentGetIcon", optional=true)
    @WeaklyLinked
    public native UIImage getIcon(float var1);

    @Bridge(symbol="AudioComponentGetLastActiveTime", optional=true)
    public native double getLastActiveTime();

    static {
        Bro.bind(AudioComponent.class);
    }

    public static class AudioComponentPtr
    extends Ptr<AudioComponent, AudioComponentPtr> {
    }

    public static class Notifications {
        public static NSObject observeRegistrationsChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AudioComponent.RegistrationsChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

