/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

public class AUScheduledAudioSlice
extends Struct<AUScheduledAudioSlice> {
    private static AtomicLong callbackId = new AtomicLong(1L);
    private static LongMap<CompletionListener> completionCallbacks = new LongMap();
    private static final Method cbComplete;

    public AUScheduledAudioSlice() {
    }

    public AUScheduledAudioSlice(AudioTimeStamp timeStamp, AUScheduledAudioSlice flags, int numberFrames, AudioBufferList bufferList) {
        this.setTimeStamp(timeStamp);
        this.setFlags(flags);
        this.setNumberFrames(numberFrames);
        this.setBufferList(bufferList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbComplete(@Pointer long userData, AUScheduledAudioSlice slice) {
        LongMap<CompletionListener> longMap = completionCallbacks;
        synchronized (longMap) {
            ((CompletionListener)completionCallbacks.get(userData)).onComplete(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionListener getCompletionListener() {
        LongMap<CompletionListener> longMap = completionCallbacks;
        synchronized (longMap) {
            return (CompletionListener)completionCallbacks.get(this.getCompletionProcUserData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletionListener(CompletionListener listener) {
        long cid = this.getCompletionProcUserData();
        if (listener == null) {
            this.setCompletionProc(null);
            this.setCompletionProcUserData(0L);
            if (cid > 0L) {
                LongMap<CompletionListener> longMap = completionCallbacks;
                synchronized (longMap) {
                    completionCallbacks.remove(cid);
                }
            }
        } else {
            if (cid == 0L) {
                cid = callbackId.getAndIncrement();
                this.setCompletionProcUserData(cid);
                this.setCompletionProc(new FunctionPtr(cbComplete));
            }
            LongMap<CompletionListener> longMap = completionCallbacks;
            synchronized (longMap) {
                completionCallbacks.put(cid, (Object)listener);
            }
        }
    }

    @StructMember(value=0)
    @ByVal
    public native AudioTimeStamp getTimeStamp();

    @StructMember(value=0)
    public native AUScheduledAudioSlice setTimeStamp(@ByVal AudioTimeStamp var1);

    @StructMember(value=1)
    private native FunctionPtr getCompletionProc();

    @StructMember(value=1)
    private native AUScheduledAudioSlice setCompletionProc(FunctionPtr var1);

    @StructMember(value=2)
    @Pointer
    private native long getCompletionProcUserData();

    @StructMember(value=2)
    private native AUScheduledAudioSlice setCompletionProcUserData(@Pointer long var1);

    @StructMember(value=3)
    public native AUScheduledAudioSlice getFlags();

    @StructMember(value=3)
    public native AUScheduledAudioSlice setFlags(AUScheduledAudioSlice var1);

    @StructMember(value=4)
    private native int getReserved();

    @StructMember(value=4)
    private native AUScheduledAudioSlice setReserved(int var1);

    @StructMember(value=5)
    private native VoidPtr getReserved2();

    @StructMember(value=5)
    private native AUScheduledAudioSlice setReserved2(VoidPtr var1);

    @StructMember(value=6)
    public native int getNumberFrames();

    @StructMember(value=6)
    public native AUScheduledAudioSlice setNumberFrames(int var1);

    @StructMember(value=7)
    public native AudioBufferList getBufferList();

    @StructMember(value=7)
    public native AUScheduledAudioSlice setBufferList(AudioBufferList var1);

    static {
        try {
            cbComplete = AUScheduledAudioSlice.class.getDeclaredMethod("cbComplete", Long.TYPE, AUScheduledAudioSlice.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static interface CompletionListener {
        public void onComplete(AUScheduledAudioSlice var1);
    }

    public static class AUScheduledAudioSlicePtr
    extends Ptr<AUScheduledAudioSlice, AUScheduledAudioSlicePtr> {
    }
}

