/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioFile;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

public class AUScheduledAudioFileRegion
extends Struct<AUScheduledAudioFileRegion> {
    private static AtomicLong callbackId = new AtomicLong(1L);
    private static LongMap<CompletionListener> completionCallbacks = new LongMap();
    private static final Method cbComplete;

    public AUScheduledAudioFileRegion() {
    }

    public AUScheduledAudioFileRegion(AudioTimeStamp timeStamp, AudioFile audioFile, int loopCount, long startFrame, int framesToPlay) {
        this.setTimeStamp(timeStamp);
        this.setAudioFile(audioFile);
        this.setLoopCount(loopCount);
        this.setStartFrame(startFrame);
        this.setFramesToPlay(framesToPlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbComplete(@Pointer long userData, AUScheduledAudioFileRegion slice, OSStatus result) {
        LongMap<CompletionListener> longMap = completionCallbacks;
        synchronized (longMap) {
            ((CompletionListener)completionCallbacks.get(userData)).onComplete(slice, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionListener getCompletionListener() {
        LongMap<CompletionListener> longMap = completionCallbacks;
        synchronized (longMap) {
            return (CompletionListener)completionCallbacks.get(this.getCompletionProcUserData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletionListener(CompletionListener listener) {
        long cid = this.getCompletionProcUserData();
        if (listener == null) {
            this.setCompletionProc(null);
            this.setCompletionProcUserData(0L);
            if (cid > 0L) {
                LongMap<CompletionListener> longMap = completionCallbacks;
                synchronized (longMap) {
                    completionCallbacks.remove(cid);
                }
            }
        } else {
            if (cid == 0L) {
                cid = callbackId.getAndIncrement();
                this.setCompletionProcUserData(cid);
                this.setCompletionProc(new FunctionPtr(cbComplete));
            }
            LongMap<CompletionListener> longMap = completionCallbacks;
            synchronized (longMap) {
                completionCallbacks.put(cid, (Object)listener);
            }
        }
    }

    @StructMember(value=0)
    @ByVal
    public native AudioTimeStamp getTimeStamp();

    @StructMember(value=0)
    public native AUScheduledAudioFileRegion setTimeStamp(@ByVal AudioTimeStamp var1);

    @StructMember(value=1)
    private native FunctionPtr getCompletionProc();

    @StructMember(value=1)
    private native AUScheduledAudioFileRegion setCompletionProc(FunctionPtr var1);

    @StructMember(value=2)
    @Pointer
    private native long getCompletionProcUserData();

    @StructMember(value=2)
    private native AUScheduledAudioFileRegion setCompletionProcUserData(@Pointer long var1);

    @StructMember(value=3)
    public native AudioFile getAudioFile();

    @StructMember(value=3)
    public native AUScheduledAudioFileRegion setAudioFile(AudioFile var1);

    @StructMember(value=4)
    public native int getLoopCount();

    @StructMember(value=4)
    public native AUScheduledAudioFileRegion setLoopCount(int var1);

    @StructMember(value=5)
    public native long getStartFrame();

    @StructMember(value=5)
    public native AUScheduledAudioFileRegion setStartFrame(long var1);

    @StructMember(value=6)
    public native int getFramesToPlay();

    @StructMember(value=6)
    public native AUScheduledAudioFileRegion setFramesToPlay(int var1);

    static {
        try {
            cbComplete = AUScheduledAudioFileRegion.class.getDeclaredMethod("cbComplete", Long.TYPE, AUScheduledAudioFileRegion.class, OSStatus.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static class AUScheduledAudioFileRegionPtr
    extends Ptr<AUScheduledAudioFileRegion, AUScheduledAudioFileRegionPtr> {
    }

    public static interface CompletionListener {
        public void onComplete(AUScheduledAudioFileRegion var1, OSStatus var2);
    }
}

