/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AUMutableRenderActionFlags;
import org.robovm.apple.audiotoolbox.AUNodeInteraction;
import org.robovm.apple.audiotoolbox.AURenderCallback;
import org.robovm.apple.audiotoolbox.AURenderCallbackStruct;
import org.robovm.apple.audiotoolbox.AudioComponentDescription;
import org.robovm.apple.audiotoolbox.AudioUnit;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AudioToolbox")
public class AUGraph
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static LongMap<AURenderCallback> renderCallbacks = new LongMap();
    private static final Method cbRender;

    protected AUGraph() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbRender(@Pointer long refCon, AUMutableRenderActionFlags actionFlags, AudioTimeStamp timeStamp, int busNumber, int numberFrames, AudioBufferList data) {
        LongMap<AURenderCallback> longMap = renderCallbacks;
        synchronized (longMap) {
            OSStatus status = OSStatus.NO_ERR;
            try {
                ((AURenderCallback)renderCallbacks.get(refCon)).onRender(actionFlags, timeStamp, busNumber, numberFrames, data);
            }
            catch (OSStatusException e) {
                status = e.getStatus();
            }
            return status;
        }
    }

    public static AUGraph create() throws OSStatusException {
        AUGraphPtr ptr = new AUGraphPtr();
        OSStatus status = AUGraph.create0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (AUGraph)ptr.get();
    }

    public int addNode(AudioComponentDescription description) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.addNode0(description, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void removeNode(int node) throws OSStatusException {
        OSStatus status = this.removeNode0(node);
        OSStatusException.throwIfNecessary(status);
    }

    public int getNodeCount() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getNodeCount0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public int getIndNode(int index) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getIndNode0(index, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public AudioComponentDescription getNodeDescription(int node) throws OSStatusException {
        AudioComponentDescription.AudioComponentDescriptionPtr ptr = new AudioComponentDescription.AudioComponentDescriptionPtr();
        OSStatus status = this.getNodeInfo0(node, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return (AudioComponentDescription)ptr.get();
    }

    public AudioUnit getNodeAudioUnit(int node) throws OSStatusException {
        AudioUnit.AudioUnitPtr ptr = new AudioUnit.AudioUnitPtr();
        OSStatus status = this.getNodeInfo0(node, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AudioUnit)ptr.get();
    }

    public void connectNodeInput(int sourceNode, int sourceOutputNumber, int destNode, int destInputNumber) throws OSStatusException {
        OSStatus status = this.connectNodeInput0(sourceNode, sourceOutputNumber, destNode, destInputNumber);
        OSStatusException.throwIfNecessary(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInputCallback(int destNode, int destInputNumber, AURenderCallback inputCallback) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        AURenderCallbackStruct struct = new AURenderCallbackStruct(new FunctionPtr(cbRender), cid);
        OSStatus status = this.setNodeInputCallback0(destNode, destInputNumber, struct);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<AURenderCallback> longMap = renderCallbacks;
            synchronized (longMap) {
                renderCallbacks.put(cid, (Object)inputCallback);
            }
        }
    }

    public void disconnectNodeInput(int destNode, int destInputNumber) throws OSStatusException {
        OSStatus status = this.disconnectNodeInput0(destNode, destInputNumber);
        OSStatusException.throwIfNecessary(status);
    }

    public void clearConnections() throws OSStatusException {
        OSStatus status = this.clearConnections0();
        OSStatusException.throwIfNecessary(status);
    }

    public int getNumberOfInteractions() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getNumberOfInteractions0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public AUNodeInteraction getInteractionInfo(int interactionIndex) throws OSStatusException {
        AUNodeInteraction.AUNodeInteractionPtr ptr = new AUNodeInteraction.AUNodeInteractionPtr();
        OSStatus status = this.getInteractionInfo0(interactionIndex, ptr);
        OSStatusException.throwIfNecessary(status);
        return (AUNodeInteraction)ptr.get();
    }

    public int countNodeInteractions(int node) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.countNodeInteractions0(node, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public AUNodeInteraction[] getNodeInteractions(int node) throws OSStatusException {
        return this.getNodeInteractions(node, this.countNodeInteractions(node));
    }

    public AUNodeInteraction[] getNodeInteractions(int node, int maxInteractions) throws OSStatusException {
        IntPtr count = new IntPtr(maxInteractions);
        AUNodeInteraction.AUNodeInteractionPtr ptr = new AUNodeInteraction.AUNodeInteractionPtr();
        OSStatus status = this.getNodeInteractions0(node, count, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            AUNodeInteraction[] result = new AUNodeInteraction[count.get()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (AUNodeInteraction)((AUNodeInteraction.AUNodeInteractionPtr)ptr.next(i)).get();
            }
            return result;
        }
        return null;
    }

    public boolean update() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.update0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void open() throws OSStatusException {
        OSStatus status = this.open0();
        OSStatusException.throwIfNecessary(status);
    }

    public void initialize() throws OSStatusException {
        OSStatus status = this.initialize0();
        OSStatusException.throwIfNecessary(status);
    }

    public void uninitialize() throws OSStatusException {
        OSStatus status = this.uninitialize0();
        OSStatusException.throwIfNecessary(status);
    }

    public void start() throws OSStatusException {
        OSStatus status = this.start0();
        OSStatusException.throwIfNecessary(status);
    }

    public void stop() throws OSStatusException {
        OSStatus status = this.stop0();
        OSStatusException.throwIfNecessary(status);
    }

    public boolean isOpen() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.isOpen0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isInitialized() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.isInitialized0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isRunning() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.isRunning0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public float getCPULoad() throws OSStatusException {
        FloatPtr ptr = new FloatPtr();
        OSStatus status = this.getCPULoad0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public float getMaxCPULoad() throws OSStatusException {
        FloatPtr ptr = new FloatPtr();
        OSStatus status = this.getMaxCPULoad0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderNotify(AURenderCallback callback) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        OSStatus status = this.addRenderNotify0(new FunctionPtr(cbRender), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<AURenderCallback> longMap = renderCallbacks;
            synchronized (longMap) {
                renderCallbacks.put(cid, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderNotify(AURenderCallback callback) throws OSStatusException {
        LongMap<AURenderCallback> longMap = renderCallbacks;
        synchronized (longMap) {
            for (LongMap.Entry entry : renderCallbacks.entries()) {
                if (entry.value != callback) continue;
                OSStatus status = this.removeRenderNotify0(new FunctionPtr(cbRender), entry.key);
                OSStatusException.throwIfNecessary(status);
            }
        }
    }

    @Bridge(symbol="NewAUGraph", optional=true)
    private static native OSStatus create0(AUGraphPtr var0);

    @Bridge(symbol="AUGraphAddNode", optional=true)
    protected native OSStatus addNode0(AudioComponentDescription var1, IntPtr var2);

    @Bridge(symbol="AUGraphRemoveNode", optional=true)
    protected native OSStatus removeNode0(int var1);

    @Bridge(symbol="AUGraphGetNodeCount", optional=true)
    protected native OSStatus getNodeCount0(IntPtr var1);

    @Bridge(symbol="AUGraphGetIndNode", optional=true)
    protected native OSStatus getIndNode0(int var1, IntPtr var2);

    @Bridge(symbol="AUGraphNodeInfo", optional=true)
    protected native OSStatus getNodeInfo0(int var1, AudioComponentDescription.AudioComponentDescriptionPtr var2, AudioUnit.AudioUnitPtr var3);

    @Bridge(symbol="AUGraphConnectNodeInput", optional=true)
    protected native OSStatus connectNodeInput0(int var1, int var2, int var3, int var4);

    @Bridge(symbol="AUGraphSetNodeInputCallback", optional=true)
    protected native OSStatus setNodeInputCallback0(int var1, int var2, AURenderCallbackStruct var3);

    @Bridge(symbol="AUGraphDisconnectNodeInput", optional=true)
    protected native OSStatus disconnectNodeInput0(int var1, int var2);

    @Bridge(symbol="AUGraphClearConnections", optional=true)
    protected native OSStatus clearConnections0();

    @Bridge(symbol="AUGraphGetNumberOfInteractions", optional=true)
    protected native OSStatus getNumberOfInteractions0(IntPtr var1);

    @Bridge(symbol="AUGraphGetInteractionInfo", optional=true)
    protected native OSStatus getInteractionInfo0(int var1, AUNodeInteraction.AUNodeInteractionPtr var2);

    @Bridge(symbol="AUGraphCountNodeInteractions", optional=true)
    protected native OSStatus countNodeInteractions0(int var1, IntPtr var2);

    @Bridge(symbol="AUGraphGetNodeInteractions", optional=true)
    protected native OSStatus getNodeInteractions0(int var1, IntPtr var2, AUNodeInteraction.AUNodeInteractionPtr var3);

    @Bridge(symbol="AUGraphUpdate", optional=true)
    protected native OSStatus update0(BooleanPtr var1);

    @Bridge(symbol="AUGraphOpen", optional=true)
    protected native OSStatus open0();

    @Bridge(symbol="AUGraphInitialize", optional=true)
    protected native OSStatus initialize0();

    @Bridge(symbol="AUGraphUninitialize", optional=true)
    protected native OSStatus uninitialize0();

    @Bridge(symbol="AUGraphStart", optional=true)
    protected native OSStatus start0();

    @Bridge(symbol="AUGraphStop", optional=true)
    protected native OSStatus stop0();

    @Bridge(symbol="AUGraphIsOpen", optional=true)
    protected native OSStatus isOpen0(BooleanPtr var1);

    @Bridge(symbol="AUGraphIsInitialized", optional=true)
    protected native OSStatus isInitialized0(BooleanPtr var1);

    @Bridge(symbol="AUGraphIsRunning", optional=true)
    protected native OSStatus isRunning0(BooleanPtr var1);

    @Bridge(symbol="AUGraphGetCPULoad", optional=true)
    protected native OSStatus getCPULoad0(FloatPtr var1);

    @Bridge(symbol="AUGraphGetMaxCPULoad", optional=true)
    protected native OSStatus getMaxCPULoad0(FloatPtr var1);

    @Bridge(symbol="AUGraphAddRenderNotify", optional=true)
    protected native OSStatus addRenderNotify0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="AUGraphRemoveRenderNotify", optional=true)
    protected native OSStatus removeRenderNotify0(FunctionPtr var1, @Pointer long var2);

    static {
        try {
            cbRender = AudioUnit.class.getDeclaredMethod("cbRender", Long.TYPE, AUMutableRenderActionFlags.class, AudioTimeStamp.class, Integer.TYPE, Integer.TYPE, AudioBufferList.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AUGraph.class);
    }

    public static class AUGraphPtr
    extends Ptr<AUGraph, AUGraphPtr> {
    }
}

