/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.assetslibrary;

import java.util.List;
import java.util.Map;
import org.robovm.apple.assetslibrary.ALAssetProperty;
import org.robovm.apple.assetslibrary.ALAssetRepresentation;
import org.robovm.apple.assetslibrary.ALAssetType;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.corelocation.CLLocation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.imageio.CGImageProperties;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Deprecated
@Library(value="AssetsLibrary")
@NativeClass
public class ALAsset
extends NSObject {
    public ALAsset() {
    }

    protected ALAsset(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected ALAsset(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Deprecated
    @Property(selector="originalAsset")
    public native ALAsset getOriginalAsset();

    @Deprecated
    @Property(selector="isEditable")
    public native boolean isEditable();

    public ALAssetType getType() {
        NSString val = this.getPropertyValue(ALAssetProperty.Type, NSString.class);
        if (val != null) {
            return ALAssetType.valueOf(val);
        }
        return null;
    }

    @WeaklyLinked
    public CLLocation getLocation() {
        CLLocation val = this.getPropertyValue(ALAssetProperty.Location, CLLocation.class);
        if (val != null) {
            return val;
        }
        return null;
    }

    public double getDuration() {
        NSNumber val = this.getPropertyValue(ALAssetProperty.Duration, NSNumber.class);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    @WeaklyLinked
    public CGImagePropertyOrientation getOrientation() {
        NSNumber val = this.getPropertyValue(ALAssetProperty.Orientation, NSNumber.class);
        if (val != null) {
            return CGImagePropertyOrientation.valueOf(val.longValue());
        }
        return null;
    }

    public NSDate getDate() {
        NSDate val = this.getPropertyValue(ALAssetProperty.Date, NSDate.class);
        if (val != null) {
            return val;
        }
        return null;
    }

    public List<String> getRepresentations() {
        NSArray val = this.getPropertyValue(ALAssetProperty.Representations, NSArray.class);
        if (val != null) {
            return val.asStringList();
        }
        return null;
    }

    public Map<String, NSURL> getURLs() {
        NSDictionary val = this.getPropertyValue(ALAssetProperty.URLs, NSDictionary.class);
        if (val != null) {
            return val.asStringMap();
        }
        return null;
    }

    public NSURL getAssetURL() {
        NSURL val = this.getPropertyValue(ALAssetProperty.AssetURL, NSURL.class);
        if (val != null) {
            return val;
        }
        return null;
    }

    private <T> T getPropertyValue(ALAssetProperty property, Class<T> type) {
        NSObject val = this.getValue(property);
        if (val != null && val.equals(ALAsset.getInvalidProperty())) {
            return null;
        }
        return (T)val;
    }

    @Deprecated
    @GlobalValue(symbol="ALErrorInvalidProperty", optional=true)
    public static native NSString getInvalidProperty();

    @Deprecated
    @Method(selector="valueForProperty:")
    public native NSObject getValue(ALAssetProperty var1);

    @Deprecated
    @Method(selector="defaultRepresentation")
    public native ALAssetRepresentation getDefaultRepresentation();

    @Deprecated
    @Method(selector="representationForUTI:")
    public native ALAssetRepresentation getRepresentation(String var1);

    @Deprecated
    @Method(selector="thumbnail")
    @WeaklyLinked
    public native CGImage getThumbnail();

    @Deprecated
    @Method(selector="aspectRatioThumbnail")
    @WeaklyLinked
    public native CGImage getAspectRatioThumbnail();

    @Deprecated
    @Method(selector="writeModifiedImageDataToSavedPhotosAlbum:metadata:completionBlock:")
    @WeaklyLinked
    public native void writeModifiedImageData(NSData var1, CGImageProperties var2, @Block VoidBlock2<NSURL, NSError> var3);

    @Deprecated
    @Method(selector="writeModifiedVideoAtPathToSavedPhotosAlbum:completionBlock:")
    public native void writeModifiedVideo(NSURL var1, @Block VoidBlock2<NSURL, NSError> var2);

    @Deprecated
    @Method(selector="setImageData:metadata:completionBlock:")
    @WeaklyLinked
    public native void setImageData(NSData var1, CGImageProperties var2, @Block VoidBlock2<NSURL, NSError> var3);

    @Deprecated
    @Method(selector="setVideoAtPath:completionBlock:")
    public native void setVideo(NSURL var1, @Block VoidBlock2<NSURL, NSError> var2);

    static {
        ObjCRuntime.bind(ALAsset.class);
    }

    public static class ALAssetPtr
    extends Ptr<ALAsset, ALAssetPtr> {
    }
}

