/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.addressbook.ABGroupProperty;
import org.robovm.apple.addressbook.ABPerson;
import org.robovm.apple.addressbook.ABPersonSortOrdering;
import org.robovm.apple.addressbook.ABRecord;
import org.robovm.apple.addressbook.ABSource;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AddressBook")
public class ABGroup
extends ABRecord {
    public String getName() {
        CFString val = this.getValue(ABGroupProperty.Name, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABGroup setName(String name) throws NSErrorException {
        if (name == null) {
            this.setValue(ABGroupProperty.Name, null);
        } else {
            this.setValue(ABGroupProperty.Name, new CFString(name));
        }
        return this;
    }

    @Deprecated
    @Bridge(symbol="ABGroupCreate", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public static native ABGroup create();

    @Deprecated
    @Bridge(symbol="ABGroupCreateInSource", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public static native ABGroup create(ABSource var0);

    @Deprecated
    @Bridge(symbol="ABGroupCopySource", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public native ABSource getSource();

    @Deprecated
    @Bridge(symbol="ABGroupCopyArrayOfAllMembers", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getAllMembers();

    @Deprecated
    @Bridge(symbol="ABGroupCopyArrayOfAllMembersWithSortOrdering", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getAllMembers(ABPersonSortOrdering var1);

    @Deprecated
    public boolean addMember(ABPerson person) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.addMember(person, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Bridge(symbol="ABGroupAddMember", optional=true)
    private native boolean addMember(ABPerson var1, NSError.NSErrorPtr var2);

    @Deprecated
    public boolean removeMember(ABPerson member) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeMember(member, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Bridge(symbol="ABGroupRemoveMember", optional=true)
    private native boolean removeMember(ABPerson var1, NSError.NSErrorPtr var2);

    static {
        Bro.bind(ABGroup.class);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<ABGroup> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<ABGroup> list = new ArrayList<ABGroup>();
            long n = o.size();
            for (long i = 0L; i < n; ++i) {
                ABRecord record = o.get(i, ABRecord.class);
                list.add((ABGroup)NativeObject.Marshaler.toObject(ABGroup.class, (long)record.getHandle(), (long)flags));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<ABGroup> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (ABGroup i : l) {
                ((CFArray)array).add(i);
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
}

