/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.monitor.athena.filter;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.ServerInvocationOperation;
import com.meidusa.venus.URL;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.monitor.athena.AthenaTransactionId;
import com.meidusa.venus.monitor.athena.reporter.ClientTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.MetricReporter;
import com.meidusa.venus.monitor.athena.reporter.ProblemReporter;
import com.meidusa.venus.monitor.athena.reporter.ServerTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.DefaultClientTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.DefaultMetricReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.DefaultProblemReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.DefaultServerTransactionReporter;
import com.meidusa.venus.support.VenusThreadContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.slf4j.Logger;

public class ServerAthenaMonitorFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private MetricReporter metricReporter = null;
    private ProblemReporter problemReporter = null;
    private ClientTransactionReporter clientTransactionReporter = null;
    private ServerTransactionReporter serverTransactionReporter = null;

    public void init() throws RpcException {
        this.metricReporter = new DefaultMetricReporter();
        this.problemReporter = new DefaultProblemReporter();
        this.clientTransactionReporter = new DefaultClientTransactionReporter();
        this.serverTransactionReporter = new DefaultServerTransactionReporter();
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            AthenaTransactionId transactionId;
            ServerInvocationOperation serverInvocation = (ServerInvocationOperation)invocation;
            if (serverInvocation.getAthenaId() == null && (transactionId = this.clientTransactionReporter.newTransaction()) != null && transactionId.getRootId() != null) {
                serverInvocation.setAthenaId(transactionId.getRootId().getBytes());
                serverInvocation.setParentId(transactionId.getParentId().getBytes());
                serverInvocation.setMessageId(transactionId.getMessageId().getBytes());
            }
            if (serverInvocation.getAthenaId() == null && logger.isWarnEnabled()) {
                logger.warn("athena rootId/parnetId/messageId is null,skip report.");
                return null;
            }
            Tuple data = serverInvocation.getData();
            SerializeServiceRequestPacket request = serverInvocation.getServiceRequestPacket();
            String apiName = request.apiName;
            long startTime = TimeUtil.currentTimeMillis();
            VenusThreadContext.set((String)"serverBeginTime", (Object)startTime);
            this.metricReporter.metric(apiName + ".handleRequest");
            AthenaTransactionId transactionId2 = new AthenaTransactionId();
            transactionId2.setRootId(new String(serverInvocation.getAthenaId()));
            transactionId2.setParentId(new String(serverInvocation.getParentId()));
            transactionId2.setMessageId(new String(serverInvocation.getMessageId()));
            this.serverTransactionReporter.startTransaction(transactionId2, apiName);
            this.serverTransactionReporter.setInputSize(((byte[])data.right).length);
            return null;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerAthenaMonitorFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        try {
            ServerInvocationOperation serverInvocation = (ServerInvocationOperation)invocation;
            if (serverInvocation.getAthenaId() == null && logger.isWarnEnabled()) {
                logger.warn("athena rootId/parnetId/messageId is null,skip report.");
                return null;
            }
            SerializeServiceRequestPacket request = serverInvocation.getServiceRequestPacket();
            String apiName = request.apiName;
            this.metricReporter.metric(apiName + ".error");
            this.problemReporter.problem(e.getMessage(), e);
            return null;
        }
        catch (Throwable ex) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerAthenaMonitorFilter.beforeInvoke error.", ex);
            }
            return null;
        }
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            ServerInvocationOperation serverInvocation = (ServerInvocationOperation)invocation;
            if (serverInvocation.getAthenaId() == null && logger.isWarnEnabled()) {
                logger.warn("athena rootId/parnetId/messageId is null,skip report.");
                return null;
            }
            SerializeServiceRequestPacket request = serverInvocation.getServiceRequestPacket();
            String apiName = request.apiName;
            this.metricReporter.metric(apiName + ".complete");
            Long startTime = (Long)VenusThreadContext.get((String)"serverBeginTime");
            long endRunTime = TimeUtil.currentTimeMillis();
            Tuple data = serverInvocation.getData();
            long queuedTime = startTime - (Long)data.left;
            long executeTime = endRunTime - startTime;
            Integer serverOutputSize = (Integer)VenusThreadContext.get((String)"serverOutputSize");
            if (serverOutputSize != null) {
                this.serverTransactionReporter.setOutputSize(serverOutputSize.intValue());
            }
            this.serverTransactionReporter.commit();
            return null;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerAthenaMonitorFilter.afterInvoke error.", e);
            }
            return null;
        }
    }

    public void destroy() throws RpcException {
    }
}

