/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.simple;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.client.ServiceFactory;
import com.meidusa.venus.client.simple.SimpleInvocationHandler;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.authenticate.DummyAuthenticator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class SimpleServiceFactory
implements ServiceFactory {
    private VenusExceptionFactory venusExceptionFactory;
    private Authenticator authenticator;
    private int soTimeout = 15000;
    private int coTimeout = 5000;
    private Map<Class<?>, Tuple<Object, SimpleInvocationHandler>> servicesMap = new HashMap();
    private String host;
    private int port;

    public SimpleServiceFactory(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getCoTimeout() {
        return this.coTimeout;
    }

    public void setCoTimeout(int coTimeout) {
        this.coTimeout = coTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getService(Class<T> t) {
        Tuple<Object, SimpleInvocationHandler> object = this.servicesMap.get(t);
        if (object == null) {
            Map<Class<?>, Tuple<Object, SimpleInvocationHandler>> map = this.servicesMap;
            synchronized (map) {
                object = this.servicesMap.get(t);
                if (object == null) {
                    T obj = this.initService(t, this.host, this.port);
                    return obj;
                }
            }
        }
        return (T)object.left;
    }

    protected <T> T initService(Class<T> t, String host, int port) {
        SimpleInvocationHandler invocationHandler = new SimpleInvocationHandler(host, port, this.coTimeout, this.soTimeout);
        if (this.venusExceptionFactory == null) {
            XmlVenusExceptionFactory venusExceptionFactory = new XmlVenusExceptionFactory();
            venusExceptionFactory.setConfigFiles(new String[]{"classpath:com/meidusa/venus/exception/VenusSystemException.xml"});
            venusExceptionFactory.init();
            this.venusExceptionFactory = venusExceptionFactory;
        }
        invocationHandler.setVenusExceptionFactory(this.getVenusExceptionFactory());
        if (this.getAuthenticator() == null) {
            this.authenticator = new DummyAuthenticator();
        }
        invocationHandler.setSerializeType(this.getAuthenticator().getSerializeType());
        Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{t}, (InvocationHandler)invocationHandler);
        for (Method method : t.getMethods()) {
            Class<?>[] eclazz;
            Endpoint endpoint = method.getAnnotation(Endpoint.class);
            if (endpoint == null) continue;
            for (Class<?> clazz : eclazz = method.getExceptionTypes()) {
                if (this.venusExceptionFactory == null || !CodedException.class.isAssignableFrom(clazz)) continue;
                this.venusExceptionFactory.addException(clazz);
            }
        }
        Tuple serviceTuple = new Tuple(object, (Object)invocationHandler);
        this.servicesMap.put(t, (Tuple<Object, SimpleInvocationHandler>)serviceTuple);
        return (T)object;
    }

    @Override
    public void destroy() {
    }
}

