/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.simple;

import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.VenusInvocationHandler;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.InvalidParameterException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.io.authenticate.Authenticator;
import com.meidusa.venus.io.network.VenusBIOConnection;
import com.meidusa.venus.io.network.VenusBIOConnectionFactory;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusAnnotationUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleInvocationHandler
extends VenusInvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(SimpleInvocationHandler.class);
    @Autowired
    private VenusExceptionFactory venusExceptionFactory;
    private static AtomicLong sequenceId = new AtomicLong(1L);
    private InvocationListenerContainer container = new InvocationListenerContainer();
    private VenusBIOConnectionFactory connFactory = new VenusBIOConnectionFactory();
    private Authenticator<HandshakePacket, AuthenPacket> authenticator = null;

    public SimpleInvocationHandler(String host, int port, int coTimeout, int soTimeout) {
        this.connFactory.setHost(host);
        this.connFactory.setPort(port);
        this.connFactory.setCoTimeout(coTimeout);
        this.connFactory.setSoTimeout(soTimeout);
    }

    public Authenticator<HandshakePacket, AuthenPacket> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<HandshakePacket, AuthenPacket> authenticator) {
        this.authenticator = authenticator;
        this.connFactory.setAuthenticator(authenticator);
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object invokeRemoteService(Service service, Endpoint endpoint, Method method, EndpointParameter[] params, Object[] args) throws Exception {
        SerializeServiceRequestPacket serviceRequestPacket = null;
        Serializer serializer = SerializerFactory.getSerializer((short)this.connFactory.getAuthenticator().getSerializeType());
        serviceRequestPacket = new SerializeServiceRequestPacket(serializer, null);
        serviceRequestPacket.clientId = PacketConstant.VENUS_CLIENT_ID;
        serviceRequestPacket.clientRequestId = sequenceId.getAndIncrement();
        serviceRequestPacket.apiName = VenusAnnotationUtils.getApiname((Method)method, (Service)service, (Endpoint)endpoint);
        serviceRequestPacket.serviceVersion = service.version();
        serviceRequestPacket.parameterMap = new HashMap();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (args[i] instanceof InvocationListener) {
                    ReferenceInvocationListener listener = new ReferenceInvocationListener();
                    ServicePacketBuffer buffer = new ServicePacketBuffer(16);
                    buffer.writeLengthCodedString(args[i].getClass().getName(), "utf-8");
                    buffer.writeInt(System.identityHashCode(args[i]));
                    listener.setIdentityData(buffer.toByteBuffer().array());
                    Type type = method.getGenericParameterTypes()[i];
                    if (!(type instanceof ParameterizedType)) throw new InvalidParameterException("invocationListener is not generic");
                    ParameterizedType genericType = (ParameterizedType)type;
                    this.container.putInvocationListener((InvocationListener)args[i], genericType.getActualTypeArguments()[0]);
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), listener);
                } else {
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), args[i]);
                }
                ++i;
            }
        }
        VenusBIOConnection conn = this.connFactory.makeObject();
        try {
            conn.write(serviceRequestPacket.toByteArray());
            if (endpoint.timeWait() > 0) {
                conn.setSoTimeout(endpoint.timeWait());
            }
            if (this.connFactory.getSoTimeout() > 0 && this.connFactory.getSoTimeout() != endpoint.timeWait()) {
                conn.setSoTimeout(this.connFactory.getSoTimeout());
            }
            byte[] bts = conn.read();
            int type = AbstractServicePacket.getType((byte[])bts);
            switch (type) {
                case -1: {
                    ErrorPacket error = new ErrorPacket();
                    error.init(bts);
                    Exception e = this.venusExceptionFactory.getException(error.errorCode, error.message);
                    if (e == null) {
                        throw new DefaultVenusException(error.errorCode, error.message);
                    }
                    if (error.additionalData == null) throw e;
                    Map tmap = Utils.getBeanFieldType(e.getClass(), Exception.class);
                    if (tmap == null) throw e;
                    if (tmap.size() <= 0) throw e;
                    Map obj = serializer.decode(error.additionalData, tmap);
                    BeanUtils.copyProperties((Object)e, (Object)obj);
                    throw e;
                }
                case 1: {
                    OKPacket ok = new OKPacket();
                    ok.init(bts);
                    return null;
                }
                case 0x2000002: {
                    SerializeServiceResponsePacket response = null;
                    response = new SerializeServiceResponsePacket(serializer, method.getGenericReturnType());
                    response.init(bts);
                    Object object = response.result;
                    return object;
                }
            }
            logger.warn("unknow response type=" + type);
            return null;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

