/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.io.network.VenusBackendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PongPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.io.utils.VenusLoggerUtil;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.util.Utils;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusNIOMessageHandler
implements MessageHandler<VenusBackendConnection> {
    private static Logger logger = LoggerFactory.getLogger(VenusNIOMessageHandler.class);
    private InvocationListenerContainer container;
    private VenusExceptionFactory venusExceptionFactory;

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public InvocationListenerContainer getContainer() {
        return this.container;
    }

    public void setContainer(InvocationListenerContainer container) {
        this.container = container;
    }

    public void handle(VenusBackendConnection conn, byte[] message) {
        int type = AbstractServicePacket.getType((byte[])message);
        switch (type) {
            case -1: {
                ErrorPacket error = new ErrorPacket();
                error.init(message);
                Exception e = this.venusExceptionFactory.getException(error.errorCode, error.message);
                if (e == null) {
                    logger.error("receive error packet,errorCode=" + error.errorCode + ",message=" + error.message, (Throwable)e);
                    break;
                }
                if (error.additionalData != null) {
                    Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
                    Map obj = serializer.decode(error.additionalData, Utils.getBeanFieldType(e.getClass(), Exception.class));
                    try {
                        BeanUtils.copyProperties((Object)e, (Object)obj);
                    }
                    catch (Exception e1) {
                        logger.error("copy properties error", (Throwable)e1);
                    }
                }
                logger.error("receive error packet", (Throwable)e);
                break;
            }
            case 1: {
                OKPacket ok = new OKPacket();
                ok.init(message);
                break;
            }
            case 0x2000002: {
                break;
            }
            case 0x4000001: {
                SerializeServiceNofityPacket packet = null;
                ServicePacketBuffer buffer = new ServicePacketBuffer(message);
                buffer.setPosition(28);
                String listenerClass = buffer.readLengthCodedString("utf-8");
                int identityHashCode = buffer.readInt();
                Tuple<InvocationListener, Type> tuple = this.container.getInvocationListener(listenerClass, identityHashCode);
                Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
                packet = new SerializeServiceNofityPacket(serializer, (Type)tuple.right);
                packet.init(message);
                VenusLoggerUtil.logRequest((byte[])packet.traceId, (String)packet.apiName);
                if (packet.errorCode != 0) {
                    Exception exception = this.venusExceptionFactory.getException(packet.errorCode, packet.errorMessage);
                    if (exception == null) {
                        exception = new DefaultVenusException(packet.errorCode, packet.errorMessage);
                    } else if (packet.additionalData != null) {
                        Map obj = serializer.decode(packet.additionalData, Utils.getBeanFieldType(exception.getClass(), Exception.class));
                        try {
                            BeanUtils.copyProperties((Object)exception, (Object)obj);
                        }
                        catch (Exception e1) {
                            logger.error("copy properties error", (Throwable)e1);
                        }
                    }
                    ((InvocationListener)tuple.left).onException(exception);
                    break;
                }
                ((InvocationListener)tuple.left).callback(packet.callbackObject);
                break;
            }
            case 0x1000002: {
                break;
            }
            case 0x1000001: {
                PongPacket pong = new PongPacket();
                conn.write(pong.toByteBuffer());
                break;
            }
        }
    }
}

