package com.meidusa.venus.client.simple;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.client.ServiceFactory;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.io.authenticate.Authenticator;

/**
 * 
 * <b>ӷ񹤳:</b>
 * <br/>
 * <li>ûӳ,ÿ󶼽,Ժر.</li>
 * <li>ֻĳIP,Port,ַҪͬ</li>
 * <li>ֻ֧ص</li>
 * <br/>
 * <b>ʹó:</b>
 * <pre>
 * ʹ̶ַ,ʹƵʽٵ.
 * ʹô:
 * SimpleServiceFactory factory = new SimpleServiceFactory("127.0.0.1",16800);
 * factory.setSoTimeout(16 * 1000);//ѡ,Ĭ 15
 * factory.setCoTimeout(5 * 1000);//ѡ,Ĭ5
 * HelloService helloService = factory.getService(HelloService.class);
 * </pre>
 * 
 * @author structchen
 *
 */
public class SimpleServiceFactory implements ServiceFactory {
	private VenusExceptionFactory venusExceptionFactory;
	private Authenticator authenticator;
	
	/**
	 * ȡݰĳʱʱ
	 */
	private int soTimeout = 15 * 1000;
	
	/**
	 * ӳʱʱ
	 */
	private int coTimeout = 5 * 1000;
	private Map<Class<?>,Tuple<Object,SimpleInvocationHandler>> servicesMap = new HashMap<Class<?>,Tuple<Object,SimpleInvocationHandler>>();
	private String host ;
	private int port;
	
	public SimpleServiceFactory(String host,int port){
		this.host = host;
		this.port = port;
	}
	
	public Authenticator getAuthenticator() {
		return authenticator;
	}

	public void setAuthenticator(Authenticator authenticator) {
		this.authenticator = authenticator;
	}

	public VenusExceptionFactory getVenusExceptionFactory() {
		return venusExceptionFactory;
	}

	public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
		this.venusExceptionFactory = venusExceptionFactory;
	}

	public int getSoTimeout() {
		return soTimeout;
	}

	public void setSoTimeout(int soTimeout) {
		this.soTimeout = soTimeout;
	}

	public int getCoTimeout() {
		return coTimeout;
	}

	public void setCoTimeout(int coTimeout) {
		this.coTimeout = coTimeout;
	}

	@Override
	public <T> T getService(Class<T> t) {
		Tuple<Object,SimpleInvocationHandler> object = servicesMap.get(t);
		if( object == null){
			synchronized (servicesMap) {
				if( object == null){
					T obj = initService(t,host,port);
					return obj;
				}
			}
		}
		return (T)object.left;
	}
	

	protected  <T> T initService(Class<T> t,String host,int port){
		SimpleInvocationHandler invocationHandler = new SimpleInvocationHandler(host,port,coTimeout,soTimeout);
		invocationHandler.setVenusExceptionFactory(this.getVenusExceptionFactory());
		if(getAuthenticator() != null){
			invocationHandler.setSerializeType(getAuthenticator().getSerializeType());
		}
		
		T object = (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{t}, invocationHandler);
		
		
		for(Method method : t.getMethods()){
			Endpoint endpoint =	method.getAnnotation(Endpoint.class);
			if(endpoint != null){
				Class[] eclazz = method.getExceptionTypes();
				for(Class clazz : eclazz){
					if(venusExceptionFactory != null && CodedException.class.isAssignableFrom(clazz)){
						venusExceptionFactory.addException(clazz);
					}
				}
			}
		}
		
		Tuple<Object,SimpleInvocationHandler> serviceTuple = new Tuple<Object,SimpleInvocationHandler>(object,invocationHandler);
		servicesMap.put(t, serviceTuple);
		return object;
	}
	@Override
	public void destroy() {
		// TODO Auto-generated method stub

	}
}
