/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.net;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.io.AbstractPacketMetaData;
import com.meidusa.toolkit.net.io.FramedInputStream;
import com.meidusa.toolkit.net.io.FramingOutputStream;
import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;
import com.meidusa.venus.client.authenticate.Authenticator;
import com.meidusa.venus.client.authenticate.DummyAuthenticator;
import com.meidusa.venus.io.Status;
import com.meidusa.venus.io.VenusPacketMetaData;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.poolable.ObjectPool;
import com.meidusa.venus.poolable.PoolableObject;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusNIOConnection
extends AuthingableConnection
implements PoolableObject {
    private static Logger logger = LoggerFactory.getLogger(VenusNIOConnection.class);
    private Authenticator<HandshakePacket, AuthenPacket> authenticator = new DummyAuthenticator<AuthenPacket>();
    private long lastPingTime = System.currentTimeMillis();
    private long lastPongTime = System.currentTimeMillis();
    private long pingInterval = 10000L;
    private static VenusPacketMetaData PACKET_META_DATA = new VenusPacketMetaData();
    private Status status = Status.WAITE_HANDSHAKE;
    private short serializeType;
    private ObjectPool objectPool;
    private boolean active;

    public VenusNIOConnection(SocketChannel channel, long createStamp) {
        super(channel, createStamp);
        this._outQueue.setMaxSize(1000);
    }

    public short getSerializeType() {
        return this.serializeType;
    }

    protected PacketInputStream createPacketInputStream() {
        return new FramedInputStream((AbstractPacketMetaData)PACKET_META_DATA, true);
    }

    protected PacketOutputStream createPacketOutputStream() {
        return new FramingOutputStream((AbstractPacketMetaData)PACKET_META_DATA, true);
    }

    public void postMessage(byte[] msg) {
        ByteBuffer buff = ByteBuffer.wrap(msg);
        this.postMessage(buff);
    }

    public boolean needPing(long now) {
        return now - this.lastPingTime > this.pingInterval && now - this.lastMessageSent > this.pingInterval;
    }

    protected void messageProcess(byte[] msg) {
        if (msg == null || msg.length < 24) {
            if (logger.isInfoEnabled()) {
                logger.info("conn ID=" + this.getId() + " , received packet size error, size=" + (msg == null ? 0 : msg.length));
            }
            this.postClose(new IllegalArgumentException("packet size error size=" + (msg == null ? 0 : msg.length)));
            return;
        }
        int type = AbstractServicePacket.getType((byte[])msg);
        if (type == 0x1000002) {
            this.lastPongTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("receive pong packet from " + this.getId());
            }
        } else {
            super.messageProcess(msg);
        }
    }

    public void ping(long now) {
        this.lastPingTime = System.currentTimeMillis();
        this.postMessage(new PingPacket().toByteBuffer());
        if (logger.isDebugEnabled()) {
            logger.debug("send ping packet to " + this.getId());
        }
    }

    public boolean checkIdle(long now) {
        boolean idle = super.checkIdle(now);
        if (!idle && this.lastPingTime - this.lastPongTime > 2L * this.pingInterval) {
            logger.warn("receive pong packet timeout, id=" + this.getId() + ",lastPingTime=" + new Date(this.lastPingTime) + ",lastPongTime =" + new Date(this.lastPongTime));
            return true;
        }
        return false;
    }

    public ObjectPool getObjectPool() {
        return this.objectPool;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isRemovedFromPool() {
        return this.objectPool == null;
    }

    public void setActive(boolean isactive) {
        this.active = isactive;
    }

    public void setObjectPool(ObjectPool pool) {
        this.objectPool = pool;
    }

    public void handleMessage(Connection conn, byte[] message) {
        if (AbstractServicePacket.getType((byte[])message) == -1) {
            this.setAuthenticated(false);
            ErrorPacket error = new ErrorPacket();
            error.init(message);
            logger.error("handShake with host=" + this.getId() + ", errorCode=" + error.errorCode + " ,message=" + error.message + ",hashCode=" + ((Object)((Object)this)).hashCode());
            return;
        }
        if (this.status == Status.WAITE_HANDSHAKE) {
            if (logger.isDebugEnabled()) {
                logger.debug("1. handShake with " + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            HandshakePacket handpacket = new HandshakePacket();
            handpacket.init(message);
            AuthenPacket authen = this.getAuthenticator().createAuthenPacket(handpacket);
            this.serializeType = authen.shakeSerializeType;
            authen.capabilities |= 0x80;
            this.status = Status.AUTHING;
            if (logger.isDebugEnabled()) {
                logger.debug("2. authing packet sent to server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            this.postMessage(authen.toByteBuffer());
        } else if (this.status == Status.AUTHING) {
            if (AbstractServicePacket.getType((byte[])message) == 1) {
                if (logger.isInfoEnabled()) {
                    logger.info("3. authing success from server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
                }
                this.setAuthenticated(true);
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("3. authing fail from server:" + this.getId() + ",hashCode=" + ((Object)((Object)this)).hashCode());
            }
            this.setAuthenticated(false);
            return;
        }
    }

    public Authenticator<HandshakePacket, AuthenPacket> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<HandshakePacket, AuthenPacket> authenticator) {
        this.authenticator = authenticator;
    }

    public boolean checkValid() {
        return !this.isClosed() && this.isAuthenticated();
    }
}

