/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.view;

import com.meidusa.venus.backend.view.AbstractXMLSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastorXMLSerializer
extends AbstractXMLSerializer {
    private static Logger logger = LoggerFactory.getLogger(CastorXMLSerializer.class);
    public static final String configFile = "/castor-mapping.xml";
    private static XMLContext context = new XMLContext();

    static {
        Mapping mapping = new Mapping();
        try {
            URL mappingUrl = CastorXMLSerializer.class.getResource(configFile);
            if (mappingUrl != null) {
                mapping.loadMapping(mappingUrl);
                context.addMapping(mapping);
            }
        }
        catch (MappingException e) {
            logger.debug("", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public String serialize(Object o) throws Exception {
        StringWriter writer = new StringWriter();
        Marshaller castorMarshaller = CastorXMLSerializer.getCongiuredMashaller(writer);
        castorMarshaller.marshal(o);
        String data = writer.toString();
        writer.close();
        return data;
    }

    public static Marshaller getCongiuredMashaller(Writer writer) throws IOException {
        Marshaller castorMarshaller = context.createMarshaller();
        castorMarshaller.setWriter(writer);
        castorMarshaller.setSuppressNamespaces(true);
        castorMarshaller.setSuppressXSIType(true);
        return castorMarshaller;
    }
}

