/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.profiling;

import com.meidusa.venus.backend.profiling.ProfilingTimerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilTimerStack {
    protected static ThreadLocal<ProfilingTimerBean> current = new ThreadLocal();
    public static final String ACTIVATE_PROPERTY = "venus.profile.activate";
    public static final String MIN_TIME = "venus.profile.mintime";
    private static final Logger LOG = LoggerFactory.getLogger(UtilTimerStack.class);
    private static boolean active = Boolean.getBoolean("venus.profile.activate");

    public static void push(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        ProfilingTimerBean currentTimer = current.get();
        if (currentTimer != null) {
            currentTimer.addChild(newTimer);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean currentTimer = current.get();
        if (currentTimer != null && name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                UtilTimerStack.printTimes(currentTimer);
                current.set(null);
            } else {
                current.set(parent);
            }
        } else if (currentTimer != null) {
            UtilTimerStack.printTimes(currentTimer);
            current.set(null);
            LOG.warn("Unmatched Timer.  Was expecting " + currentTimer.getResource() + ", instead got " + name);
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        if (LOG.isInfoEnabled()) {
            LOG.info(currentTimer.getPrintable(UtilTimerStack.getMinTime()));
        }
    }

    private static long getMinTime() {
        try {
            return Long.parseLong(System.getProperty(MIN_TIME, "0"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void setActive(boolean active) {
        if (active) {
            System.setProperty(ACTIVATE_PROPERTY, "true");
        } else {
            System.clearProperty(ACTIVATE_PROPERTY);
        }
        UtilTimerStack.active = active;
    }

    public static <T> T profile(String name, ProfilingBlock<T> block) throws Exception {
        UtilTimerStack.push(name);
        try {
            T t = block.doProfiling();
            return t;
        }
        finally {
            UtilTimerStack.pop(name);
        }
    }

    public static interface ProfilingBlock<T> {
        public T doProfiling() throws Exception;
    }
}

