/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastmark.feature.SerializerFeature;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.util.InetAddressUtil;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.annotations.ExceptionCode;
import com.meidusa.venus.annotations.RemoteException;
import com.meidusa.venus.backend.DefaultEndpointInvocation;
import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.VenusStatus;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.network.handler.RemotingInvocationListener;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.backend.services.xml.bean.PerformanceLogger;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.ExceptionLevel;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.exception.ServiceVersionNotAllowException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.io.packet.PongPacket;
import com.meidusa.venus.io.packet.ServiceAPIPacket;
import com.meidusa.venus.io.packet.ServiceHeadPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.VenusStatusRequestPacket;
import com.meidusa.venus.io.packet.VenusStatusResponsePacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.ClasspathAnnotationScanner;
import com.meidusa.venus.util.Range;
import com.meidusa.venus.util.UUID;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusTracerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceInvokeMessageHandler
implements MessageHandler<VenusFrontendConnection, Tuple<Long, byte[]>>,
Initialisable {
    private static SerializerFeature[] JSON_FEATURE;
    private static final String TIMEOUT = "waiting-timeout for execution,api=%s,ip=%s,time=%d (ms)";
    static Map<Class<?>, Integer> codeMap;
    private static String ENDPOINT_INVOKED_TIME;
    private static Logger logger;
    private static Logger INVOKER_LOGGER;
    private static Logger performanceLogger;
    private int maxExecutionThread;
    private int threadLiveTime = 30;
    private boolean executorEnabled = false;
    private boolean executorProtected;
    private boolean useThreadLocalExecutor;
    private Executor executor;
    private VenusExceptionFactory venusExceptionFactory;
    @Autowired
    private ServiceManager serviceManager;

    static {
        Map rmap;
        JSON_FEATURE = new SerializerFeature[]{SerializerFeature.ShortString};
        codeMap = new HashMap();
        Map map = ClasspathAnnotationScanner.find(Exception.class, ExceptionCode.class);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                codeMap.put((Class)entry.getKey(), ((ExceptionCode)entry.getValue()).errorCode());
            }
        }
        if ((rmap = ClasspathAnnotationScanner.find(Exception.class, RemoteException.class)) != null) {
            for (Map.Entry entry : rmap.entrySet()) {
                codeMap.put((Class)entry.getKey(), ((RemoteException)entry.getValue()).errorCode());
            }
        }
        ENDPOINT_INVOKED_TIME = "invoked Totle Time: ";
        logger = LoggerFactory.getLogger(ServiceInvokeMessageHandler.class);
        INVOKER_LOGGER = LoggerFactory.getLogger((String)"venus.service.invoker");
        performanceLogger = LoggerFactory.getLogger((String)"venus.backend.performance");
    }

    public boolean isExecutorEnabled() {
        return this.executorEnabled;
    }

    public void setExecutorEnabled(boolean executorEnabled) {
        this.executorEnabled = executorEnabled;
    }

    public boolean isExecutorProtected() {
        return this.executorProtected;
    }

    public boolean isUseThreadLocalExecutor() {
        return this.useThreadLocalExecutor;
    }

    public void setUseThreadLocalExecutor(boolean useThreadLocalExecutor) {
        this.useThreadLocalExecutor = useThreadLocalExecutor;
    }

    public void setExecutorProtected(boolean executorProtected) {
        this.executorProtected = executorProtected;
    }

    public int getThreadLiveTime() {
        return this.threadLiveTime;
    }

    public void setThreadLiveTime(int threadLiveTime) {
        this.threadLiveTime = threadLiveTime;
    }

    public int getMaxExecutionThread() {
        return this.maxExecutionThread;
    }

    public void setMaxExecutionThread(int maxExecutionThread) {
        this.maxExecutionThread = maxExecutionThread;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    /*
     * Unable to fully structure code
     */
    public void handle(VenusFrontendConnection conn, Tuple<Long, byte[]> data) {
        waitTime = TimeUtil.currentTimeMillis() - (Long)data.left;
        message = (byte[])data.right;
        type = AbstractServicePacket.getType((byte[])message);
        routerPacket = null;
        serializeType = conn.getSerializeType();
        sourceIp = conn.getHost();
        if (0x8000001 == type) {
            routerPacket = new VenusRouterPacket();
            routerPacket.original = message;
            routerPacket.init(message);
            type = AbstractServicePacket.getType((byte[])routerPacket.data);
            message = routerPacket.data;
            serializeType = routerPacket.serializeType;
            sourceIp = InetAddressUtil.intToAddress((int)routerPacket.srcIP);
        }
        packetSerializeType = serializeType;
        finalSourceIp = sourceIp;
        switch (type) {
            case 0x1000001: {
                ping = new PingPacket();
                ping.init(message);
                pong = new PongPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)ping, (AbstractServicePacket)pong);
                this.postMessageBack((Connection)conn, null, (AbstractServicePacket)ping, (AbstractServicePacket)pong);
                if (!ServiceInvokeMessageHandler.logger.isDebugEnabled()) break;
                ServiceInvokeMessageHandler.logger.debug("receive ping packet from " + conn.getHost() + ":" + conn.getPort());
                break;
            }
            case 0x1000002: {
                break;
            }
            case 0x5000001: {
                sr = new VenusStatusRequestPacket();
                sr.init(message);
                response = new VenusStatusResponsePacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)sr, (AbstractServicePacket)response);
                if (sr.newStatus != 0) {
                    VenusStatus.getInstance().setStatus(sr.newStatus);
                }
                response.status = VenusStatus.getInstance().getStatus();
                this.postMessageBack((Connection)conn, null, (AbstractServicePacket)sr, (AbstractServicePacket)response);
                break;
            }
            case 0x2000001: {
                request = null;
                ep = null;
                apiPacket = new ServiceAPIPacket();
                try {
                    packetBuffer = new ServicePacketBuffer(message);
                    apiPacket.init((AbstractPacketBuffer)packetBuffer);
                    ep = this.getServiceManager().getEndpoint(apiPacket.apiName);
                    serializer = SerializerFactory.getSerializer((short)packetSerializeType);
                    request = new SerializeServiceRequestPacket(serializer, ep.getParameterTypeDict());
                    packetBuffer.setPosition(0);
                    request.init((AbstractPacketBuffer)packetBuffer);
                    VenusTracerUtil.logReceive((byte[])request.traceId, (String)request.apiName, (String)JSON.toJSONString((Object)request.parameterMap, (SerializerFeature[])ServiceInvokeMessageHandler.JSON_FEATURE));
                }
                catch (Exception e) {
                    error = new ErrorPacket();
                    AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)error);
                    if (e instanceof CodedException || ServiceInvokeMessageHandler.codeMap.containsKey(e.getClass())) {
                        if (e instanceof CodedException) {
                            codeEx = (CodedException)e;
                            error.errorCode = codeEx.getErrorCode();
                        } else {
                            error.errorCode = ServiceInvokeMessageHandler.codeMap.get(e.getClass());
                        }
                    } else {
                        error.errorCode = e instanceof JSONException != false || e instanceof SerializeException != false ? 18004000 : 18005000;
                    }
                    error.message = e.getMessage();
                    this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)error);
                    if (request != null) {
                        this.logPerformance(ep, UUID.toString((byte[])request.traceId), apiPacket.apiName, waitTime, 0L, conn.getHost(), finalSourceIp, request.clientId, request.clientRequestId, request.parameterMap, error);
                        if (e instanceof VenusExceptionLevel) {
                            if (((VenusExceptionLevel)e).getLevel() != null) {
                                this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), ServiceInvokeMessageHandler.logger, String.valueOf(e.getMessage()) + " client:{clientID=" + apiPacket.clientId + ",ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ", apiName=" + apiPacket.apiName + "}", e);
                            }
                        } else if (ServiceInvokeMessageHandler.logger.isDebugEnabled()) {
                            ServiceInvokeMessageHandler.logger.debug(String.valueOf(e.getMessage()) + " [ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ", apiName=" + apiPacket.apiName + "]", (Throwable)e);
                        }
                    } else {
                        ServiceInvokeMessageHandler.logger.error(String.valueOf(e.getMessage()) + " [ip=" + conn.getHost() + ":" + conn.getPort() + ",sourceIP=" + finalSourceIp + ", apiName=" + apiPacket.apiName + "]", (Throwable)e);
                    }
                    return;
                }
                apiName = request.apiName;
                endpoint = ep;
                resultType = EndpointInvocation.ResultType.RESPONSE;
                invocationListener = null;
                if (endpoint.isVoid()) {
                    resultType = EndpointInvocation.ResultType.OK;
                    if (endpoint.isAsync()) {
                        resultType = EndpointInvocation.ResultType.NONE;
                    }
                    var26_25 = endpoint.getMethod().getParameterTypes();
                    var25_26 = var26_25.length;
                    var24_28 = 0;
                    while (var24_28 < var25_26) {
                        clazz = var26_25[var24_28];
                        if (InvocationListener.class.isAssignableFrom(clazz)) {
                            resultType = EndpointInvocation.ResultType.NOTIFY;
                            break;
                        }
                        ++var24_28;
                    }
                }
                for (Map.Entry<K, V> entry : request.parameterMap.entrySet()) {
                    if (!(entry.getValue() instanceof ReferenceInvocationListener)) continue;
                    invocationListener = new RemotingInvocationListener<T>(conn, (ReferenceInvocationListener)entry.getValue(), request, routerPacket);
                    request.parameterMap.put((String)entry.getKey(), invocationListener);
                }
                errorPacket = null;
                if (errorPacket == null) {
                    errorPacket = ServiceInvokeMessageHandler.checkVersion(endpoint, (AbstractServiceRequestPacket)request);
                }
                if (errorPacket == null) {
                    errorPacket = ServiceInvokeMessageHandler.checkActive(endpoint, (AbstractServiceRequestPacket)request);
                }
                isTimeout = false;
                if (errorPacket == null && (errorPacket = ServiceInvokeMessageHandler.checkTimeout(conn, endpoint, (AbstractServiceRequestPacket)request, waitTime)) != null) {
                    isTimeout = true;
                }
                if (errorPacket == null) ** GOTO lbl120
                if (resultType != EndpointInvocation.ResultType.NOTIFY) ** GOTO lbl117
                if (isTimeout) ** GOTO lbl120
                if (invocationListener != null) {
                    invocationListener.onException((Exception)new ServiceVersionNotAllowException(errorPacket.message));
                } else {
                    this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)errorPacket);
                }
                ** GOTO lbl118
lbl117:
                // 1 sources

                this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)request, (AbstractServicePacket)errorPacket);
lbl118:
                // 3 sources

                this.logPerformance(endpoint, UUID.toString((byte[])request.traceId), apiName, waitTime, 0L, conn.getHost(), finalSourceIp, request.clientId, request.clientRequestId, request.parameterMap, errorPacket);
                return;
lbl120:
                // 2 sources

                paramters = request.parameterMap;
                requestFinal = request;
                resultTypeFinal = resultType;
                invocationListenerFinal = invocationListener;
                finalRouterPacket = routerPacket;
                traceID = request.traceId;
                if (this.executor == null) {
                    new ServiceRunnable(conn, resultTypeFinal, data, endpoint, traceID, apiName, finalSourceIp, (AbstractServiceRequestPacket)requestFinal, packetSerializeType, finalRouterPacket, paramters, invocationListenerFinal).run();
                    break;
                }
                this.executor.execute((Runnable)new ServiceRunnable(conn, resultTypeFinal, data, endpoint, traceID, apiName, finalSourceIp, (AbstractServiceRequestPacket)requestFinal, packetSerializeType, finalRouterPacket, paramters, invocationListenerFinal));
                break;
            }
            default: {
                buffer = new StringBuilder("receive unknown packet type=" + type + "  from ");
                buffer.append(String.valueOf(conn.getHost()) + ":" + conn.getPort()).append("\n");
                buffer.append("-------------------------------").append("\n");
                buffer.append(StringUtil.dumpAsHex((byte[])message, (int)message.length)).append("\n");
                buffer.append("-------------------------------").append("\n");
                head = new ServiceHeadPacket();
                head.init(message);
                error = new ErrorPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)head, (AbstractServicePacket)error);
                error.errorCode = 18007001;
                error.message = "receive unknown packet type=" + type + "  from " + conn.getHost() + ":" + conn.getPort();
                this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)head, (AbstractServicePacket)error);
            }
        }
    }

    protected void logPerformance(Endpoint endpoint, String traceId, String apiName, long queuedTime, long executTime, String remoteIp, String sourceIP, long clientId, long requestId, Map<String, Object> parameterMap, Object result) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(queuedTime).append(",").append(executTime).append("]ms, (*server*) traceID=").append(traceId).append(", api=").append(apiName).append(", ip=").append(remoteIp).append(", sourceIP=").append(sourceIP).append(", clientID=").append(clientId).append(", requestID=").append(requestId);
        PerformanceLogger pLevel = null;
        if (endpoint != null) {
            pLevel = endpoint.getPerformanceLogger();
        }
        if (pLevel != null) {
            if (pLevel.isPrintParams()) {
                buffer.append(", params=");
                buffer.append(JSON.toJSONString(parameterMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
            }
            if (pLevel.isPrintResult()) {
                buffer.append(", result=");
                if (result instanceof ErrorPacket) {
                    buffer.append("{ errorCode=").append(((ErrorPacket)result).errorCode);
                    buffer.append(", message=").append(((ErrorPacket)result).message);
                    buffer.append("}");
                } else if (result instanceof Response) {
                    if (((Response)result).getErrorCode() > 0) {
                        buffer.append("{ errorCode=").append(((Response)result).getErrorCode());
                        buffer.append(", message=\"").append(((Response)result).getErrorMessage()).append("\"");
                        buffer.append(", className=\"").append(((Response)result).getException().getClass().getSimpleName()).append("\"");
                        buffer.append("}");
                    } else {
                        buffer.append(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
                    }
                }
            }
            if (queuedTime >= (long)pLevel.getError() || executTime >= (long)pLevel.getError() || queuedTime + executTime >= (long)pLevel.getError()) {
                if (performanceLogger.isErrorEnabled()) {
                    performanceLogger.error(buffer.toString());
                }
            } else if (queuedTime >= (long)pLevel.getWarn() || executTime >= (long)pLevel.getWarn() || queuedTime + executTime >= (long)pLevel.getWarn()) {
                if (performanceLogger.isWarnEnabled()) {
                    performanceLogger.warn(buffer.toString());
                }
            } else if (queuedTime >= (long)pLevel.getInfo() || executTime >= (long)pLevel.getInfo() || queuedTime + executTime >= (long)pLevel.getInfo()) {
                if (performanceLogger.isInfoEnabled()) {
                    performanceLogger.info(buffer.toString());
                }
            } else if (performanceLogger.isDebugEnabled()) {
                performanceLogger.debug(buffer.toString());
            }
        } else {
            if (performanceLogger.isDebugEnabled()) {
                buffer.append(", params=");
                buffer.append(JSON.toJSONString(parameterMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
                if (result == null) {
                    buffer.append(", result=<null>");
                } else {
                    buffer.append(", result=");
                    if (result instanceof ErrorPacket) {
                        buffer.append("{ errorCode=").append(((ErrorPacket)result).errorCode);
                        buffer.append(", message=").append(((ErrorPacket)result).message);
                        buffer.append("}");
                    } else if (result instanceof Response) {
                        if (((Response)result).getErrorCode() > 0) {
                            buffer.append("{errorCode=").append(((Response)result).getErrorCode());
                            buffer.append(", message=\"").append(((Response)result).getErrorMessage()).append("\"");
                            buffer.append(", className=\"").append(((Response)result).getException().getClass().getSimpleName()).append("\"");
                            buffer.append("}");
                        } else {
                            buffer.append(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
                        }
                    }
                }
            }
            if (queuedTime >= 30000L || executTime >= 30000L || queuedTime + executTime >= 30000L) {
                if (performanceLogger.isErrorEnabled()) {
                    performanceLogger.error(buffer.toString());
                }
            } else if (queuedTime >= 10000L || executTime >= 10000L || queuedTime + executTime >= 10000L) {
                if (performanceLogger.isWarnEnabled()) {
                    performanceLogger.warn(buffer.toString());
                }
            } else if (queuedTime >= 5000L || executTime >= 5000L || queuedTime + executTime >= 5000L) {
                if (performanceLogger.isInfoEnabled()) {
                    performanceLogger.info(buffer.toString());
                }
            } else if (performanceLogger.isDebugEnabled()) {
                performanceLogger.debug(buffer.toString());
            }
        }
    }

    private void logDependsOnLevel(ExceptionLevel level, Logger specifiedLogger, String msg, Throwable e) {
        switch (level) {
            case DEBUG: {
                specifiedLogger.debug(msg, e);
                break;
            }
            case INFO: {
                specifiedLogger.info(msg, e);
                break;
            }
            case TRACE: {
                specifiedLogger.trace(msg, e);
                break;
            }
            case WARN: {
                specifiedLogger.warn(msg, e);
                break;
            }
            case ERROR: {
                specifiedLogger.error(msg, e);
                break;
            }
        }
    }

    private static ErrorPacket checkTimeout(VenusFrontendConnection conn, Endpoint endpoint, AbstractServiceRequestPacket request, long waitTime) {
        if (waitTime > (long)endpoint.getTimeWait()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005001;
            error.message = String.format(TIMEOUT, request.apiName, conn.getLocalHost(), waitTime);
            return error;
        }
        return null;
    }

    private static ErrorPacket checkActive(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        if (!service.isActive() || !endpoint.isActive()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005006;
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service=").append(endpoint.getService().getName());
            if (!service.isActive()) {
                buffer.append(" is not active");
            }
            if (!endpoint.isActive()) {
                buffer.append(", endpoint=").append(endpoint.getName()).append(" is not active");
            }
            error.message = buffer.toString();
            return error;
        }
        return null;
    }

    private static ErrorPacket checkVersion(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        Range range = service.getVersionRange();
        if (range == null || range.contains(request.serviceVersion)) {
            return null;
        }
        ErrorPacket error = new ErrorPacket();
        AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
        error.errorCode = 18005007;
        error.message = "Service=" + endpoint.getService().getName() + ",version=" + request.serviceVersion + " not allow";
        return error;
    }

    protected RequestContext createContext(RequestInfo info, Connection conn, Endpoint endpoint, Map<String, Object> paramters) {
        RequestContext context = new RequestContext();
        context.setParameters(paramters);
        context.setEndPointer(endpoint);
        context.setRequestInfo(info);
        return context;
    }

    private Response handleRequest(RequestContext context, Connection conn, Endpoint endpoint) {
        Response response = new Response();
        DefaultEndpointInvocation invocation = new DefaultEndpointInvocation(context, endpoint);
        try {
            try {
                response.setResult(invocation.invoke());
            }
            catch (Throwable e) {
                if (e instanceof ServiceInvokeException) {
                    e = ((ServiceInvokeException)e).getTargetException();
                }
                if (e instanceof Exception) {
                    response.setException((Exception)e);
                } else {
                    response.setException((Exception)new DefaultVenusException(e.getMessage(), e));
                }
                Integer code = codeMap.get(e.getClass());
                if (code != null) {
                    response.setErrorCode(code);
                    response.setErrorMessage(e.getMessage());
                } else if (e instanceof CodedException) {
                    response.setErrorCode(((CodedException)e).getErrorCode());
                    response.setErrorMessage(((CodedException)e).getMessage());
                } else {
                    int errorCode = 0;
                    if (this.venusExceptionFactory != null) {
                        errorCode = this.venusExceptionFactory.getErrorCode(e.getClass());
                        if (errorCode != 0) {
                            response.setErrorCode(errorCode);
                        } else {
                            response.setErrorCode(18005000);
                        }
                    } else {
                        response.setErrorCode(18005000);
                    }
                    if (e instanceof NullPointerException && e.getMessage() == null) {
                        response.setErrorMessage("Server Side error caused by NullPointerException");
                    } else {
                        response.setErrorMessage(e.getMessage());
                    }
                }
                Service service = endpoint.getService();
                if (e instanceof VenusExceptionLevel) {
                    if (((VenusExceptionLevel)e).getLevel() != null) {
                        this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), INVOKER_LOGGER, String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (e instanceof RuntimeException && !(e instanceof CodedException)) {
                    INVOKER_LOGGER.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                } else if (endpoint.isAsync()) {
                    if (INVOKER_LOGGER.isErrorEnabled()) {
                        INVOKER_LOGGER.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (INVOKER_LOGGER.isDebugEnabled()) {
                    INVOKER_LOGGER.debug(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                }
                UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
            }
        }
        finally {
            UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
        }
        return response;
    }

    private RequestInfo getRequestInfo(byte packetSerializeType, VenusFrontendConnection conn, VenusRouterPacket routerPacket, AbstractServiceRequestPacket packet) {
        RequestInfo info = new RequestInfo();
        if (routerPacket != null) {
            info.setRemoteIp(InetAddressUtil.intToAddress((int)routerPacket.srcIP));
        } else {
            info.setRemoteIp(conn.getHost());
        }
        info.setProtocol(RequestInfo.Protocol.SOCKET);
        info.setClientId(conn.getClientId());
        if (packetSerializeType == 0) {
            info.setAccept("application/json");
        } else if (packetSerializeType != 1 && packetSerializeType == 2) {
            info.setAccept("application/xml");
        }
        return info;
    }

    public void init() throws InitialisationException {
        if (this.executor == null && this.executorEnabled && !this.useThreadLocalExecutor && this.maxExecutionThread > 0) {
            this.executor = Executors.newFixedThreadPool(this.maxExecutionThread);
        }
    }

    public void postMessageBack(Connection conn, VenusRouterPacket routerPacket, AbstractServicePacket source, AbstractServicePacket result) {
        if (routerPacket == null) {
            conn.write(result.toByteBuffer());
        } else {
            routerPacket.data = result.toByteArray();
            conn.write(routerPacket.toByteBuffer());
        }
    }

    static /* synthetic */ RequestInfo access$1(ServiceInvokeMessageHandler serviceInvokeMessageHandler, byte by, VenusFrontendConnection venusFrontendConnection, VenusRouterPacket venusRouterPacket, AbstractServiceRequestPacket abstractServiceRequestPacket) {
        return serviceInvokeMessageHandler.getRequestInfo(by, venusFrontendConnection, venusRouterPacket, abstractServiceRequestPacket);
    }

    static /* synthetic */ Response access$2(ServiceInvokeMessageHandler serviceInvokeMessageHandler, RequestContext requestContext, Connection connection, Endpoint endpoint) {
        return serviceInvokeMessageHandler.handleRequest(requestContext, connection, endpoint);
    }

    static /* synthetic */ Logger access$3() {
        return logger;
    }
}

