package com.meidusa.venus.backend.network.handler;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.exception.ServiceNotCallbackException;
import com.meidusa.venus.exception.ServiceVersionNotAllowException;
import com.meidusa.venus.exception.VenusExceptionCodeConstant;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.backend.DefaultEndpointInvocation;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.EndpointInvocation.ResultType;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.network.VenusClientConnection;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.backend.services.xml.bean.PerformanceLogger;
import com.meidusa.venus.backend.view.MediaTypes;
import com.meidusa.venus.common.monitor.MonitorRuntime;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.io.packet.PongPacket;
import com.meidusa.venus.io.packet.ServiceAPIPacket;
import com.meidusa.venus.io.packet.ServiceHeadPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.ServiceResponsePacket;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.Range;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.concurrent.DefaultMultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiBlockingQueue;
import com.meidusa.venus.util.concurrent.MultiBlockingQueueExecutor;
import com.meidusa.venus.util.concurrent.MultiQueueRunnable;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import com.meidusa.venus.util.concurrent.MultiBlockingQueueExecutor.CallerRunsPolicy;
import com.meidusa.fastjson.JSON;
import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.util.StringUtil;

@SuppressWarnings("unchecked")
public class ServiceInvokeMessageHandler implements com.meidusa.toolkit.net.MessageHandler<VenusClientConnection>,Initialisable {
	private static String ENDPOINT_INVOKED_TIME = "invoked Totle Time: ";
    private static Logger logger = Logger.getLogger(ServiceInvokeMessageHandler.class);
    private static Logger REPORT_LOGGER = Logger.getLogger("EndpointMonitor");
    private static Logger performanceLogger = Logger.getLogger("venus.backend.performance");
    
    private ThreadLocal<Executor> threadLocal = new ThreadLocal<Executor>(){
    	public Executor initialValue(){
    		Executor executor = null;
    		if(executorEnabled){
				if(maxExecutionThread >0){
					int threadLocalExecutionThread = maxExecutionThread/Runtime.getRuntime().availableProcessors();
					if(threadLocalExecutionThread == 0) threadLocalExecutionThread = 1;
					if(executorProtected){
						final DefaultQueueConfigManager manager = new DefaultQueueConfigManager(threadLocalExecutionThread);
						@SuppressWarnings("rawtypes")
						final MultiBlockingQueue wrapper = new MultiBlockingQueue(manager);
						
						MultiBlockingQueueExecutor	multiBlockingQueueExecutor = new MultiBlockingQueueExecutor(threadLocalExecutionThread,threadLiveTime,TimeUnit.MINUTES,wrapper,new CallerRunsPolicy());
						manager.setExecutor(multiBlockingQueueExecutor);
						manager.init();
						executor = multiBlockingQueueExecutor;
					}else{
						executor = Executors.newFixedThreadPool(threadLocalExecutionThread);
					}
				}
    		}
			return executor;
		}
    };
	
	@SuppressWarnings("rawtypes")
	class DefaultQueueConfigManager extends DefaultMultiQueueManager{
		final List list = new ArrayList<Tuple<QueueConfig,Queue>>();
		int maxThread;
		private MultiBlockingQueueExecutor executor = null;
		public DefaultQueueConfigManager(int maxThread){
			this.maxThread = maxThread;
		}
		
		public void setExecutor(MultiBlockingQueueExecutor executor) {
			this.executor = executor;
		}

		public Tuple<QueueConfig,Queue> newTuple(Named named){
			Tuple<QueueConfig,Queue> tuple = super.newTuple(named);
			list.add(tuple);
			adjustMaxActive(tuple);
			return tuple;
		}
		
		public Queue createQueue(QueueConfig config){
			return new LinkedBlockingQueue(config.getMaxQueue());
		}
		
		public QueueConfig getConfig(Named named) {
			QueueConfig config = new QueueConfig();
			config.setMaxQueue(10000);
			config.setName(named.getName());
			return config;
		}
		
		public int getIdleSize(){
			if(executor == null){
				return 0;
			}
			return maxThread - executor.getRunningSize();
		}
		private void adjustMaxActive(Tuple<QueueConfig,Queue> tuple){
			int maxActive = 0;
			if(tuple.left.getAverageLatencyTime() <= 10){
				maxActive = (int) (0.9 * maxThread);
			}else if(tuple.left.getAverageLatencyTime() < 100){
				maxActive = (int) (0.8 * maxThread) ;
			}else if(tuple.left.getAverageLatencyTime() <= 1000){
				maxActive = (int) (0.5 * maxThread)  + getIdleSize();
			}else if(tuple.left.getAverageLatencyTime() <= 5000){
				maxActive = (int) (0.2 * maxThread)  + getIdleSize();
			}else if(tuple.left.getAverageLatencyTime() <= 10000){
				maxActive = (int) ((0.1 * maxThread)  + (0.7* getIdleSize()));
			}else{
				maxActive = (int) ((0.05 * maxThread) + (0.5 * getIdleSize()));
			}
			
			if(tuple.left.getMaxActive() >0 && this.getIdleSize()<= 0.05 * maxThread && tuple.left.getRunningSize() >= 0.9 * tuple.left.getMaxActive()){
				maxActive  = (int)(maxActive - 0.1 * maxThread);
			}
			
			if(maxActive ==0){
				maxActive = 1;
			}else if(maxActive >= maxThread){
				maxActive = (int) (0.9 * maxThread); 
				if(maxActive ==0){
					maxActive = 1;
				}
			}
			
			tuple.left.setMaxActive(maxActive);
		}
		
		public void init(){
			new Thread(){
				{
					this.setDaemon(true);
					this.setName("endPoint-Thread-adjust--"+Thread.currentThread().getName());
				}
				public void run(){
					while(true){
						try {
							Thread.sleep(5 * 1000L);
						} catch (InterruptedException e) {
						}
						if(list.size() <1) continue;
						List<Tuple<QueueConfig,Queue>> temp = new ArrayList<Tuple<QueueConfig,Queue>>();
						temp.addAll(list);
						REPORT_LOGGER.info("-----"+Thread.currentThread().getName()+",total="+maxThread+",idle="+getIdleSize()+"----------");
						PriorityQueue<QueueConfig> queue = new PriorityQueue<QueueConfig>(temp.size(), new Comparator<QueueConfig>(){
							@Override
							public int compare(QueueConfig o1, QueueConfig o2) {
								return (int)(o2.getAverageLatencyTime() - o1.getAverageLatencyTime());
							}
							
						});
						for(Iterator<Tuple<QueueConfig,Queue>> it = temp.iterator();it.hasNext();){
							Tuple<QueueConfig,Queue> tuple = it.next();
							REPORT_LOGGER.info("name="+tuple.left.getName()+", runningThread="+tuple.left.getRunningSize()+", maxThread="+tuple.left.getMaxActive()+", averageLatency="+tuple.left.getAverageLatencyTime()+", size="+tuple.right.size());
							adjustMaxActive(tuple);
							
							if(tuple.left.getRunningSize() > 0 && tuple.left.getAverageLatencyTime() > 0){
								queue.add(tuple.left);
							}
						}
						
						if(getIdleSize() < 0.1 * DefaultQueueConfigManager.this.maxThread){
							QueueConfig config = null;
							int targetIdleSize = (int)(0.1 * DefaultQueueConfigManager.this.maxThread);
							if(targetIdleSize == 0){
								targetIdleSize = 1;
							}
							while(queue.size()>0 && (config = queue.remove()) != null && targetIdleSize > 0){
								if(config.getRunningSize() > targetIdleSize){
									int thisDown = (int)(targetIdleSize/(queue.size()+1));
									config.setMaxActive(config.getRunningSize() - thisDown);
									targetIdleSize = targetIdleSize - thisDown;
								}
							}
						}
						
					}
				}
				
			}.start();
		}
	}
	
    private int maxExecutionThread;
    private int threadLiveTime = 30;
    private boolean executorEnabled;
    private boolean executorProtected;
    private boolean useThreadLocalExecutor;

	public boolean isExecutorEnabled() {
		return executorEnabled;
	}

	public void setExecutorEnabled(boolean executorEnabled) {
		this.executorEnabled = executorEnabled;
	}

	public boolean isExecutorProtected() {
		return executorProtected;
	}

	public boolean isUseThreadLocalExecutor() {
		return useThreadLocalExecutor;
	}

	public void setUseThreadLocalExecutor(boolean useThreadLocalExecutor) {
		this.useThreadLocalExecutor = useThreadLocalExecutor;
	}

	public void setExecutorProtected(boolean executorProtected) {
		this.executorProtected = executorProtected;
	}

	public int getThreadLiveTime() {
		return threadLiveTime;
	}

	public void setThreadLiveTime(int threadLiveTime) {
		this.threadLiveTime = threadLiveTime;
	}

	public int getMaxExecutionThread() {
		return maxExecutionThread;
	}

	public void setMaxExecutionThread(int maxExecutionThread) {
		this.maxExecutionThread = maxExecutionThread;
	}

	private Executor executor;
    
    private VenusExceptionFactory venusExceptionFactory;
    
    @Autowired
    private ServiceManager serviceManager;

	public VenusExceptionFactory getVenusExceptionFactory() {
		return venusExceptionFactory;
	}

	public Executor getExecutor() {
		return executor;
	}


	public void setExecutor(Executor executor) {
		this.executor = executor;
	}


	public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
		this.venusExceptionFactory = venusExceptionFactory;
	}

	public ServiceManager getServiceManager() {
		return serviceManager;
	}

	public void setServiceManager(ServiceManager serviceManager) {
		this.serviceManager = serviceManager;
	}

	@Override
    public void handleMessage(final VenusClientConnection conn, byte[] message) {
		
		final long received = System.currentTimeMillis();
		
        int type = AbstractServicePacket.getType(message);
        VenusRouterPacket routerPacket = null;
        
        if(PacketConstant.PACKET_TYPE_ROUTER == type){
	        routerPacket = new VenusRouterPacket();
	    	routerPacket.init(message);
	    	
	    	type = AbstractServicePacket.getType(routerPacket.data);
        }
    	
        switch (type) {
            case PacketConstant.PACKET_TYPE_PING:
                PingPacket ping = new PingPacket();
                ping.init(message);
                PongPacket pong = new PongPacket();
                AbstractServicePacket.copyHead(ping, pong);
                postMessageBack(conn,routerPacket,ping,pong);
                if (logger.isDebugEnabled()) {
                    logger.debug("receive ping packet from " + conn.getId());
                }
                break;
                
            //ignore this packet
            case PacketConstant.PACKET_TYPE_PONG:
            	break;
            	
            case PacketConstant.PACKET_TYPE_SERVICE_REQUEST:
            	SerializeServiceRequestPacket request = null;
            	try{
            		ServiceAPIPacket apiPacket = new ServiceAPIPacket();
            		try{
	            		ServicePacketBuffer packetBuffer = new ServicePacketBuffer(message);
	            		apiPacket.init(packetBuffer);
	            		
	            		Endpoint ep = getServiceManager().getEndpoint(apiPacket.apiName);
	            		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
	            		request = new SerializeServiceRequestPacket(serializer,ep.getParameterTypeDict());
	            		
            			packetBuffer.setPosition(0);
            			request.init(packetBuffer);
            		}catch(Exception e){
	                	ErrorPacket error = new ErrorPacket();
	            		AbstractServicePacket.copyHead(apiPacket, error);
						if(e instanceof CodedException){
							CodedException codeEx = (CodedException) e;
							error.errorCode = codeEx.getErrorCode();
						}else{
							error.errorCode = VenusExceptionCodeConstant.UNKNOW_EXCEPTION;
						}
	                	error.message = e.getMessage();
	                	postMessageBack(conn,routerPacket,request,error);
	                	
	                	if(e instanceof VenusExceptionLevel){
	        	    		if (logger.isEnabledFor(((VenusExceptionLevel)e).getLevel())) {
	        	    			logger.log(((VenusExceptionLevel)e).getLevel(),e.getMessage() + " client:{clientID="+apiPacket.clientId+",ip="
	        	    					+ conn.getId() + ", apiName="+apiPacket.apiName+"}", e);
	        	    		}
	            		}else{
	            			if (logger.isEnabledFor(Level.DEBUG)) {
	            				logger.debug(e.getMessage() + " [ip="
	        	    					+ conn.getId() + ", apiName="+apiPacket.apiName+"]", e);
	        	    		}
	            		}
	                	return;
            		}
	            	
	                final String apiName = request.apiName;
	                int index = apiName.lastIndexOf(".");
	                String serviceName = request.apiName.substring(0, index);
	                String methodName = request.apiName.substring(index + 1);
	                //RequestInfo info = getRequestInfo(conn, request);
	                
	                final Endpoint endpoint = getServiceManager().getEndpoint(serviceName, methodName, request.parameterMap.keySet().toArray(new String[]{}));
	                
	                ResultType resultType =  ResultType.RESPONSE;
	                RemotingInvocationListener<Serializable> invocationListener = null;
	                if(endpoint.isVoid()){
						resultType = ResultType.OK;
						if(endpoint.isAsync()){
							resultType = ResultType.NONE;
						}
						
						for(Class clazz : endpoint.getMethod().getParameterTypes()){
							if(InvocationListener.class.isAssignableFrom(clazz)){
								resultType = ResultType.NOTIFY;
								break;
							}
						}
					}
	                
	                for(Map.Entry<String, Object> entry: request.parameterMap.entrySet()){
						if(entry.getValue() instanceof ReferenceInvocationListener){
							invocationListener = new RemotingInvocationListener<Serializable>(conn,(ReferenceInvocationListener)entry.getValue(),request);
							request.parameterMap.put(entry.getKey(), invocationListener);
						}
					}
	                
	                //service version error 
	                ErrorPacket errorPacket = null;
	                
	                if(errorPacket == null){
	                	errorPacket = checkVersion(endpoint,request);
	                }
	                if(errorPacket == null){
	                	errorPacket = checkActive(endpoint, request);
	                }
	                
	                if(errorPacket != null){
	                	if(resultType == ResultType.NOTIFY){
	                		if(invocationListener != null){
	                			invocationListener.onException(new ServiceVersionNotAllowException(errorPacket.message));
	                		}else{
	                			postMessageBack(conn,routerPacket,request,errorPacket);
	                		}
	                	}else{
	                		postMessageBack(conn,routerPacket,request,errorPacket);
	                	}
	                	
	                	if (logger.isDebugEnabled()) {
	                        logger.debug("receive service request packet from " + conn.getId());
	                        logger.debug("sending response to " + conn.getId() + ": " + errorPacket + " ");
	                    }
	                	return ;
	                }
					
					final Map<String,Object> paramters = request.parameterMap;//convertService.convert(request.parameterMap, endpoint.getParameterTypeDict());
					final AbstractServiceRequestPacket requestFinal = request;
					final ResultType resultTypeFinal = resultType;
					final RemotingInvocationListener<Serializable> invocationListenerFinal = invocationListener;
					final SerializeServiceRequestPacket requestPacket = request;
					final VenusRouterPacket finalRouterPacket = routerPacket;
					class ServiceRunnable extends MultiQueueRunnable{
						@Override
						public void doRun() {
							long startRunTime = System.currentTimeMillis();
							Response result = null;
							if(conn.isClosed() && resultTypeFinal == ResultType.RESPONSE){
								return;
							}
							try{
							// invoke service endpoint
				                result = handleRequest(getRequestInfo(conn, requestFinal),conn,endpoint,paramters);
				                
				                if(result.getErrorCode() == 0){
					                if(resultTypeFinal == ResultType.RESPONSE){
					                	Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
					                	ServiceResponsePacket response = new SerializeServiceResponsePacket(serializer,endpoint.getMethod().getGenericReturnType());
					                	AbstractServicePacket.copyHead(requestFinal, response);
						                response.result = result.getResult();
						                postMessageBack(conn,finalRouterPacket,requestFinal,response);
					                }else if(resultTypeFinal == ResultType.OK){
					                	OKPacket ok = new OKPacket();
					                	AbstractServicePacket.copyHead(requestFinal, ok);
					                	postMessageBack(conn,finalRouterPacket,requestFinal,ok);
					                }else if(resultTypeFinal == ResultType.NOTIFY){
					                	if(invocationListenerFinal != null && !invocationListenerFinal.isResponsed()){
					                		invocationListenerFinal.onException(new ServiceNotCallbackException("Server side not call back error"));
					                	}
					                }
				                }else{
				                	if(resultTypeFinal == ResultType.RESPONSE || resultTypeFinal == ResultType.OK){
					                	ErrorPacket error = new ErrorPacket();
					                	AbstractServicePacket.copyHead(requestFinal, error);
					                	error.errorCode = result.getErrorCode();
					                	error.message = result.getErrorMessage();
					                	Throwable throwable = result.getException();
					                	if(throwable != null){
					                		Serializer serializer = SerializerFactory.getSerializer(conn.getSerializeType());
					                		Map<String,PropertyDescriptor> mpd = Utils.getBeanPropertyDescriptor(throwable.getClass());
					                		Map<String,Object> additionalData = new HashMap<String,Object>();
					                		
					                		for(Map.Entry<String, PropertyDescriptor> entry : mpd.entrySet()){
					                			additionalData.put(entry.getKey(),entry.getValue().getReadMethod().invoke(throwable));
					                		}
					                		error.additionalData = serializer.encode(additionalData);
					                	}
					                	
					                	postMessageBack(conn,finalRouterPacket,requestFinal,error);
				                	}else if(resultTypeFinal == ResultType.NOTIFY){
				                		if(invocationListenerFinal != null && !invocationListenerFinal.isResponsed()){
				                			if(result.getException() == null){
				                				invocationListenerFinal.onException(new DefaultVenusException(result.getErrorCode(),result.getErrorMessage()));
				                			}else{
				                				invocationListenerFinal.onException(result.getException());
				                			}
					                	}
				                	}else{
				                		
				                	}
				                }
				                
				                if (logger.isDebugEnabled()) {
				                    logger.debug("receive service request packet from " + conn.getId());
				                    logger.debug("sending response to " + conn.getId() + ": " + result + " ");
				                }
							}catch(Exception e){
								ErrorPacket error = new ErrorPacket();
			            		AbstractServicePacket.copyHead(requestFinal, error);
								if(e instanceof CodedException){
									CodedException codeEx = (CodedException) e;
									error.errorCode = codeEx.getErrorCode();
								}else{
									error.errorCode = VenusExceptionCodeConstant.UNKNOW_EXCEPTION;
								}
			                	error.message = e.getMessage();
			                	postMessageBack(conn,finalRouterPacket,requestFinal,error);
			                	logger.error("error when invoke", e);
			                	return;
			            	}catch(Error e){
			            		ErrorPacket error = new ErrorPacket();
			            		AbstractServicePacket.copyHead(requestFinal, error);
			                	error.errorCode = VenusExceptionCodeConstant.SERVICE_UNAVAILABLE_EXCEPTION;
			                	error.message = e.getMessage();
			                	postMessageBack(conn,finalRouterPacket,requestFinal,error);
			                	logger.error("error when invoke", e);
			                	return;
			            	}finally{
			            		long endRunTime = System.currentTimeMillis();
			            		
			    				long queuedTime = startRunTime - received;
			    				long executTime = endRunTime - startRunTime;
			    				MonitorRuntime.getInstance().calculateAverage(endpoint.getService().getName(), endpoint.getName(), executTime);
			    				
			    				StringBuffer buffer = new StringBuffer();
			    				buffer.append("[").append(queuedTime).append(",")
			    					  .append(executTime).append("]ms api=")
			    					  .append(apiName).append(", remote=").append(conn.getId())
			    					  .append(", clientID=").append(requestPacket.clientId).append(", requestID=").append(requestPacket.clientRequestId);
			    				
			    				PerformanceLogger pLevel =endpoint.getPerformanceLogger();
			    				if(pLevel != null){
			    					
			    					if(pLevel.isPrintParams()){
			    						buffer.append(", params=\n");
			    						buffer.append(JSON.toJSONString(requestPacket.parameterMap));
			    					}
			    					if(pLevel.isPrintResult()) {
			    						if(result == null) {
				    						buffer.append(", result=<null>");
			    						} else {
			    							buffer.append(", result=\n");
				    						buffer.append(JSON.toJSONString(result));
			    						}
			    					}
			    					
			    					if(queuedTime  >= pLevel.getError() || executTime >= pLevel.getError()){
										if(performanceLogger.isEnabledFor(Level.ERROR)){
											performanceLogger.error(buffer.toString());
										}
									}else if(queuedTime >= pLevel.getWarn() || executTime >= pLevel.getWarn()){
										if(performanceLogger.isEnabledFor(Level.WARN)){
											performanceLogger.warn(buffer.toString());
										}
									}else if(queuedTime >= pLevel.getInfo() || executTime >= pLevel.getInfo()){
										if(performanceLogger.isInfoEnabled()){
											performanceLogger.info(buffer.toString());
										}
									}else{
										if(performanceLogger.isDebugEnabled()){
											performanceLogger.debug(buffer.toString());
										}
									}
			    					
			    				}else{
			    					if(queuedTime  >= 30 * 1000 || executTime >= 30 * 1000){
										if(performanceLogger.isEnabledFor(Level.ERROR)){
											performanceLogger.error(buffer.toString());
										}
									}else if(queuedTime >= 10 * 1000 || executTime >= 10 * 1000){
										if(performanceLogger.isEnabledFor(Level.WARN)){
											performanceLogger.warn(buffer.toString());
										}
									}else if(queuedTime >= 5 * 1000 || executTime >= 5 * 1000){
										if(performanceLogger.isInfoEnabled()){
											performanceLogger.info(buffer.toString());
										}
									}else{
										if(performanceLogger.isDebugEnabled()){
											performanceLogger.debug(buffer.toString());
										}
									}
			    				}
			    				
			    				
			            	}
						}

						@Override
						public String getName() {
							return apiName;
						}
					}
					
					if(useThreadLocalExecutor){
						Executor executor = threadLocal.get();
						if(executor == null){
							new ServiceRunnable().run();
						}else{
							executor.execute(new ServiceRunnable());
						}
					}else{
						if(executor == null){
							new ServiceRunnable().run();
						}else{
							executor.execute(new ServiceRunnable());
						}
					}
					
	                
            	}catch(Exception e){
            		ErrorPacket error = new ErrorPacket();
            		AbstractServicePacket.copyHead(request, error);
                	error.errorCode = VenusExceptionCodeConstant.SERVICE_UNAVAILABLE_EXCEPTION;
                	error.message = e.getMessage();
                	postMessageBack(conn,routerPacket,request,error);
                	logger.error("error when invoke", e);
                	return;
            	}catch(Error e){
            		ErrorPacket error = new ErrorPacket();
            		AbstractServicePacket.copyHead(request, error);
                	error.errorCode = VenusExceptionCodeConstant.SERVICE_UNAVAILABLE_EXCEPTION;
                	error.message = e.getMessage();
                	postMessageBack(conn,routerPacket,request,error);
                	logger.error("error when invoke", e);
                	return;
            	}
                break;
            default:
                StringBuilder buffer = new StringBuilder("receive unknown packet type="+type+"  from ");
                buffer.append(conn.getId()).append("\n");
                buffer.append("-------------------------------").append("\n");
                buffer.append(StringUtil.dumpAsHex(message, message.length)).append("\n");
                buffer.append("-------------------------------").append("\n");
                ServiceHeadPacket head = new ServiceHeadPacket();
                head.init(message);
                ErrorPacket error = new ErrorPacket();
                
        		AbstractServicePacket.copyHead(head, error);
            	error.errorCode = VenusExceptionCodeConstant.PACKET_DECODE_EXCEPTION;
            	error.message = "receive unknown packet type="+type+"  from " + conn.getId();
            	postMessageBack(conn,routerPacket,head,error);

        }

    }
	
	private static ErrorPacket checkActive(Endpoint endpoint,AbstractServiceRequestPacket request){
		Service service = endpoint.getService();
		if(!service.isActive() || !endpoint.isActive()){
			ErrorPacket error = new ErrorPacket();
			AbstractServicePacket.copyHead(request, error);
        	error.errorCode = VenusExceptionCodeConstant.SERVICE_INACTIVE_EXCEPTION;
        	StringBuffer buffer = new StringBuffer();
        	buffer.append("Service=").append(endpoint.getService().getName());
        	if(!service.isActive()){
        		buffer.append(" is not active");
        	}
        	
        	if(!endpoint.isActive()){
        		buffer.append(", endpoint=").append(endpoint.getName()).append(" is not active");
        	}
        	
        	error.message = buffer.toString();
        	return error;
		}
		
		return null;
	}
	
	private static ErrorPacket checkVersion(Endpoint endpoint,AbstractServiceRequestPacket request){
        Service service = endpoint.getService();
        
        //service version check
        Range range = service.getVersionRange();
        if(range == null || range.contains(request.serviceVersion)){
        	return null;
        }else{
        	ErrorPacket error = new ErrorPacket();
        	AbstractServicePacket.copyHead(request, error);
        	error.errorCode = VenusExceptionCodeConstant.SERVICE_VERSION_NOT_ALLOWD_EXCEPTION;
        	error.message = "Service="+endpoint.getService().getName()+",version="+request.serviceVersion+" not allow";
        	return error;
        }
	}

    private Response  handleRequest(RequestInfo info, Connection conn,Endpoint endpoint,Map<String,Object> paramters) {
        
        RequestContext context = new RequestContext();
        context.setParameters(paramters);
        context.setEndPointer(endpoint);
        context.setRequestInfo(info);
        Response response = new Response();
        
        DefaultEndpointInvocation invocation = new DefaultEndpointInvocation(context,endpoint);
        
        try{
        	UtilTimerStack.push(ENDPOINT_INVOKED_TIME);
			response.setResult(invocation.invoke());
        }catch(Throwable e){
        	if(e instanceof ServiceInvokeException){
        		e = ((ServiceInvokeException)e).getTargetException();
        	}
        	if(e instanceof Exception){
        		response.setException((Exception)e);
        	}else{
        		response.setException(new DefaultVenusException(e.getMessage(), e));
        	}
        	if(e instanceof CodedException){
        		response.setErrorCode(((CodedException)e).getErrorCode());
        		response.setErrorMessage(((CodedException)e).getMessage());
        	}else{
        		int errorCode  = 0;
        		if(venusExceptionFactory != null){
        			errorCode = venusExceptionFactory.getErrorCode(e.getClass());
        			if(errorCode != 0){
        				response.setErrorCode(errorCode);
        			}else{
        				//unknowable exception
        				response.setErrorCode(VenusExceptionCodeConstant.UNKNOW_EXCEPTION);
        			}
        		}else{
        			//unknowable exception
        			response.setErrorCode(VenusExceptionCodeConstant.UNKNOW_EXCEPTION);
        		}
        		response.setErrorMessage(e.getMessage());
        	}
    		Service service = endpoint.getService();
    		if(e instanceof VenusExceptionLevel){
	    		if (logger.isEnabledFor(((VenusExceptionLevel)e).getLevel())) {
	    			logger.log(((VenusExceptionLevel)e).getLevel(),e.getMessage() + " "
	    					+ context.getRequestInfo().getRemoteIp() + " "
	    					+ service.getName() + ":" + endpoint.getMethod().getName()
	    					+ " " + Utils.toString(context.getParameters()), e);
	    		}
    		}else{
    			if(e instanceof RuntimeException && !(e instanceof CodedException)){
    				logger.error(e.getMessage() + " "
	    					+ context.getRequestInfo().getRemoteIp() + " "
	    					+ service.getName() + ":" + endpoint.getMethod().getName()
	    					+ " " + Utils.toString(context.getParameters()), e);
    			}else{
	    			if (logger.isEnabledFor(Level.DEBUG)) {
		    			logger.debug(e.getMessage() + " "
		    					+ context.getRequestInfo().getRemoteIp() + " "
		    					+ service.getName() + ":" + endpoint.getMethod().getName()
		    					+ " " + Utils.toString(context.getParameters()), e);
		    		}
    			}
    		}
        }finally{
        	UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
        }
        
        return response;
    }

    /**
     * extract request info from connection and packet
     * @param conn
     * @param packet
     * @return
     */
    private RequestInfo getRequestInfo(VenusClientConnection conn, AbstractServiceRequestPacket packet) {
        RequestInfo info = new RequestInfo();
        info.setRemoteIp(conn.getId().split(":")[0]);
        info.setProtocol(RequestInfo.Protocol.SOCKET);

        if (conn.getSerializeType() == PacketConstant.CONTENT_TYPE_JSON) {
            info.setAccept(MediaTypes.APPLICATION_JSON);
        } else if (conn.getSerializeType() == PacketConstant.CONTENT_TYPE_BSON) {
            //info.setAccept(MediaTypes.APPLICATION_XML);
        }else if (conn.getSerializeType() == PacketConstant.CONTENT_TYPE_OBJECT) {
            info.setAccept(MediaTypes.APPLICATION_XML);
        }

        return info;
    }

	@Override
	public void init() throws InitialisationException {
		if(executor == null){
			if(executorEnabled){
				if(!useThreadLocalExecutor){
					if(maxExecutionThread >0){
						if(this.executorProtected){
							MultiBlockingQueueExecutor multiBlockingQueueExecutor = null;
							final DefaultQueueConfigManager manager = new DefaultQueueConfigManager(this.maxExecutionThread);
							MultiBlockingQueue blockingQueue = new MultiBlockingQueue(manager);
							executor = multiBlockingQueueExecutor = new MultiBlockingQueueExecutor(maxExecutionThread,threadLiveTime,TimeUnit.MINUTES,blockingQueue,new CallerRunsPolicy());
							manager.executor = multiBlockingQueueExecutor;
							manager.init();
						}else{
							executor = Executors.newFixedThreadPool(maxExecutionThread);
						}
					}
				}
			}
		}
	}
	
	public void postMessageBack(Connection conn,VenusRouterPacket routerPacket,AbstractServicePacket source,AbstractServicePacket result){
		if(routerPacket == null){
			conn.postMessage(result.toByteBuffer());
		}else{
			routerPacket.data = result.toByteBuffer().array();
			conn.postMessage(routerPacket.toByteBuffer());
		}
	}
}
