/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.extension.xmpp;

import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.XPP3Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPPPacketReader
extends XPP3Reader {
    public XMPPPacketReader() {
    }

    public XMPPPacketReader(DocumentFactory factory) {
        super(factory);
    }

    public Document parseDocument() throws DocumentException, IOException, XmlPullParserException {
        DocumentFactory df = this.getDocumentFactory();
        Document document = df.createDocument();
        Element parent = null;
        XmlPullParser pp = this.getXPPParser();
        int count = 0;
        block10: while (true) {
            int type = -1;
            type = pp.nextToken();
            switch (type) {
                case 8: {
                    String text = pp.getText();
                    int loc = text.indexOf(" ");
                    if (loc >= 0) {
                        document.addProcessingInstruction(text.substring(0, loc), text.substring(loc + 1));
                        continue block10;
                    }
                    document.addProcessingInstruction(text, "");
                    continue block10;
                }
                case 9: {
                    if (parent != null) {
                        parent.addComment(pp.getText());
                        continue block10;
                    }
                    document.addComment(pp.getText());
                    continue block10;
                }
                case 5: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addCDATA(text);
                        continue block10;
                    }
                    if (text.trim().length() <= 0) continue block10;
                    throw new DocumentException("Cannot have text content outside of the root document");
                }
                case 6: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addText(text);
                        continue block10;
                    }
                    if (text.trim().length() <= 0) continue block10;
                    throw new DocumentException("Cannot have an entityref outside of the root document");
                }
                case 1: {
                    return document;
                }
                case 2: {
                    QName qname = pp.getPrefix() == null ? df.createQName(pp.getName(), pp.getNamespace()) : df.createQName(pp.getName(), pp.getPrefix(), pp.getNamespace());
                    Element newElement = null;
                    newElement = "jabber:client".equals(qname.getNamespaceURI()) || "jabber:server".equals(qname.getNamespaceURI()) || "jabber:connectionmanager".equals(qname.getNamespaceURI()) || "jabber:component:accept".equals(qname.getNamespaceURI()) || "http://jabber.org/protocol/httpbind".equals(qname.getNamespaceURI()) ? df.createElement(pp.getName()) : df.createElement(qname);
                    int nsStart = pp.getNamespaceCount(pp.getDepth() - 1);
                    int nsEnd = pp.getNamespaceCount(pp.getDepth());
                    int i = nsStart;
                    while (i < nsEnd) {
                        if (pp.getNamespacePrefix(i) != null) {
                            newElement.addNamespace(pp.getNamespacePrefix(i), pp.getNamespaceUri(i));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < pp.getAttributeCount()) {
                        QName qa = pp.getAttributePrefix(i) == null ? df.createQName(pp.getAttributeName(i)) : df.createQName(pp.getAttributeName(i), pp.getAttributePrefix(i), pp.getAttributeNamespace(i));
                        newElement.addAttribute(qa, pp.getAttributeValue(i));
                        ++i;
                    }
                    if (parent != null) {
                        parent.add(newElement);
                    } else {
                        document.add(newElement);
                    }
                    parent = newElement;
                    ++count;
                    continue block10;
                }
                case 3: {
                    if (parent != null) {
                        parent = parent.getParent();
                    }
                    if (--count >= 1) continue block10;
                    return document;
                }
                case 4: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addText(text);
                        continue block10;
                    }
                    if (text.trim().length() <= 0) continue block10;
                    throw new DocumentException("Cannot have text content outside of the root document");
                }
            }
        }
    }
}

