package com.meidusa.venus.extension.xmpp.io.json;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

import org.dom4j.Document;
import org.dom4j.Element;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.venus.extension.xmpp.XMPPPacketReader;

public class PacketDeserializer implements ObjectDeserializer {
	
	private static ThreadLocal<XMPPPacketReader> xmppReadThreadLocal = new ThreadLocal<XMPPPacketReader>(){
		 protected XMPPPacketReader initialValue() {
		        return new XMPPPacketReader();
		    }
	};
	
	public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
		 String id = (String) parser.parse();
	        
	        if (id == null) {
	            return null;
	        }
	        
	        try {
	        	XMPPPacketReader reader = xmppReadThreadLocal.get();
	        	Document doc = reader.read(new StringReader(id));
	        	Packet packet = null;
	        	if("iq".equals(doc.getRootElement().getName())){
	        		packet = new IQ(doc.getRootElement());
	        	}else if("presence".equals(doc.getRootElement().getName())){
	        		packet = new Presence(doc.getRootElement());
	        	}else if("message".equals(doc.getRootElement().getName())){
	        		packet = new Message(doc.getRootElement());
	        	}
	        	return (T)packet;
				
			} catch (Exception e) {
				e.printStackTrace();
				return null;
			}
	        
	}

	public int getFastMatchToken() {
		return JSONToken.LITERAL_STRING;
	}

}
