/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.extension.athena.delegate;

import com.meidusa.venus.extension.athena.AthenaClientTransaction;
import com.meidusa.venus.extension.athena.AthenaServerTransaction;
import com.meidusa.venus.extension.athena.AthenaTransactionId;

public class AthenaTransactionDelegate {
    private static AthenaTransactionDelegate delegate = new AthenaTransactionDelegate();
    private AthenaClientTransaction clientTransactionReporter;
    private AthenaServerTransaction serverTransactionReporter;

    private AthenaTransactionDelegate() {
    }

    public static AthenaTransactionDelegate getDelegate() {
        return delegate;
    }

    public void setClientTransactionReporter(AthenaClientTransaction clientTransactionReporter) {
        this.clientTransactionReporter = clientTransactionReporter;
    }

    public void setServerTransactionReporter(AthenaServerTransaction serverTransactionReporter) {
        this.serverTransactionReporter = serverTransactionReporter;
    }

    public AthenaTransactionId startClientTransaction(String itemName) {
        if (this.clientTransactionReporter != null) {
            return this.clientTransactionReporter.startTransaction(itemName);
        }
        return null;
    }

    public void completeClientTransaction() {
        if (this.clientTransactionReporter != null) {
            this.clientTransactionReporter.commit();
        }
    }

    public void startServerTransaction(AthenaTransactionId transactionId, String itemName) {
        if (this.serverTransactionReporter != null) {
            this.serverTransactionReporter.startTransaction(transactionId, itemName);
        }
    }

    public void completeServerTransaction() {
        if (this.serverTransactionReporter != null) {
            this.serverTransactionReporter.commit();
        }
    }

    public void setServerInputSize(long size) {
        if (this.serverTransactionReporter != null) {
            this.serverTransactionReporter.setInputSize(size);
        }
    }

    public void setServerOutputSize(long size) {
        if (this.serverTransactionReporter != null) {
            this.serverTransactionReporter.setOutputSize(size);
        }
    }

    public void setClientOutputSize(long size) {
        if (this.clientTransactionReporter != null) {
            this.clientTransactionReporter.setOutputSize(size);
        }
    }

    public void setClientInputSize(long size) {
        if (this.clientTransactionReporter != null) {
            this.clientTransactionReporter.setInputSize(size);
        }
    }
}

