/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet.metainfo.engine;

import com.meidusa.venus.doclet.metainfo.MethodInfo;
import com.meidusa.venus.doclet.metainfo.ParamInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentScanner {
    private static String INTERFACE_regex = "^(.*)(@Service)(.*)";
    private static String SERVICE_regex = "^(.*)(@Service\\(name=\")(.*)(\")";
    private static String PARAM_regex = "^(.*)(@param)(\\s)(\\w*)(.*)";
    private static String RETURN_regex = "^(.*)(@return)(.*)";
    private static String ENDPOINT_regex = "^(.*)(@Endpoint\\(name=\")(.*)(\")";
    private static String COMMENT_regex = "^(.*)(\\*)(.*)";
    private static String COMMENT_END = "^(.*)(\\*/)";

    public static List<MethodInfo> scanPlainSource(BufferedReader reader) throws IOException {
        String line;
        ArrayList<MethodInfo> mList = new ArrayList<MethodInfo>();
        ArrayList<ParamInfo> paramList = new ArrayList<ParamInfo>();
        StringBuffer desc = new StringBuffer(" ");
        boolean scanedServiceComment = false;
        while ((line = reader.readLine()) != null) {
            String methodName;
            ParamInfo paramInfo;
            String methodDesc;
            if (!scanedServiceComment) {
                scanedServiceComment = CommentScanner.scanedServiceComment(line);
            }
            if (!scanedServiceComment) continue;
            if (!(CommentScanner.paramStart(line) || CommentScanner.returnStart(line) || CommentScanner.commentEnd(line) || (methodDesc = CommentScanner.scanMethodDesc(line)) == null)) {
                desc.append(methodDesc);
            }
            if ((paramInfo = CommentScanner.scanParam(line)) != null) {
                paramList.add(paramInfo);
            }
            if ((methodName = CommentScanner.scanMethodName(line)) == null) continue;
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setInterfaceName(methodName);
            methodInfo.setDesc(desc.toString());
            methodInfo.setParamList(paramList);
            mList.add(methodInfo);
            desc = new StringBuffer(" ");
            paramList = new ArrayList();
        }
        return mList;
    }

    public static boolean containInterface(String text) {
        return CommentScanner.isInterface(text);
    }

    private static boolean isInterface(String text) {
        Pattern pattern = Pattern.compile(INTERFACE_regex, 32);
        Matcher m = pattern.matcher(text);
        return m.find();
    }

    private static boolean scanedServiceComment(String text) {
        Pattern pattern = Pattern.compile(SERVICE_regex, 32);
        Matcher m = pattern.matcher(text);
        return m.find();
    }

    private static String scanServiceName(String text) {
        String serviceName = null;
        Pattern pattern = Pattern.compile(SERVICE_regex, 32);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            serviceName = m.group(3);
        }
        return serviceName;
    }

    private static boolean paramStart(String text) {
        Pattern pattern = Pattern.compile(PARAM_regex, 32);
        Matcher m = pattern.matcher(text);
        return m.find();
    }

    private static boolean commentEnd(String text) {
        Pattern pattern = Pattern.compile(COMMENT_END, 32);
        Matcher m = pattern.matcher(text);
        return m.find();
    }

    private static ParamInfo scanParam(String text) {
        Pattern pattern = Pattern.compile(PARAM_regex, 32);
        Matcher m = pattern.matcher(text);
        ParamInfo paramInfo = null;
        if (m.find()) {
            paramInfo = new ParamInfo();
            paramInfo.setParamName(m.group(4));
            paramInfo.setParamComent(String.valueOf(m.group(5)) + " ");
        }
        return paramInfo;
    }

    private static boolean returnStart(String text) {
        Pattern pattern = Pattern.compile(RETURN_regex, 32);
        Matcher m = pattern.matcher(text);
        return m.find();
    }

    private static String scanMethodName(String text) {
        String methodName = null;
        Pattern pattern = Pattern.compile(ENDPOINT_regex, 32);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            methodName = m.group(3);
        }
        return methodName;
    }

    public static String scanMethodDesc(String text) {
        String desc = null;
        Pattern pattern = Pattern.compile(COMMENT_regex, 32);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            desc = m.group(3);
        }
        return desc;
    }

    public static void main(String[] args) throws IOException {
    }
}

