/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet.metainfo;

import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.doclet.metainfo.EndpointInfo;
import com.meidusa.venus.doclet.metainfo.EndpointParameterInfo;
import com.meidusa.venus.doclet.metainfo.ServiceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class MetaInfoLoaderUtil {
    public static ServiceInfo getServiceMetaInfo(Class clazz) {
        Annotation[] annotations = clazz.getAnnotations();
        ServiceInfo[] serviceInfos = new ServiceInfo[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            Service s = (Service)annotations[i];
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setShortClassName(s.name());
            serviceInfo.setVersion(String.valueOf(s.version()));
            serviceInfo.setImplement(s.implement());
            if (s.singleton()) {
                serviceInfo.setSingleton("yes");
            } else {
                serviceInfo.setSingleton("no");
            }
            serviceInfos[i] = serviceInfo;
            ++i;
        }
        return serviceInfos[0];
    }

    public static EndpointInfo getEndpointMetaInfo(Method method) {
        String returnType = method.getReturnType().toString();
        Annotation[] annotations = method.getDeclaredAnnotations();
        EndpointInfo[] endpointInfos = new EndpointInfo[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            Endpoint e = (Endpoint)annotations[i];
            EndpointInfo endpointInfo = new EndpointInfo();
            endpointInfo.setEndpointName(e.name());
            endpointInfo.setReturnType(returnType);
            if (e.async()) {
                endpointInfo.setAsync("async");
            } else {
                endpointInfo.setAsync("sync");
            }
            endpointInfos[i] = endpointInfo;
            ++i;
        }
        return endpointInfos[0];
    }

    public static EndpointParameterInfo[] getEndpointParameterMetaInfo(Method method) {
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        EndpointParameterInfo[] params = new EndpointParameterInfo[types.length];
        int i = 0;
        while (i < types.length) {
            Param param = (Param)AnnotationUtil.getAnnotation((Annotation[])annotations[i], Param.class);
            params[i] = new EndpointParameterInfo();
            params[i].setName(param.name());
            params[i].setType(types[i].toString());
            if (param.optional()) {
                params[i].setOptional("yes");
            } else {
                params[i].setOptional("no");
            }
            params[i].setDefaultValue(param.defaultValue());
            ++i;
        }
        return params;
    }

    public static void main(String[] args) throws SecurityException, NoSuchMethodException {
    }
}

