/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final FileFilter _javaFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".java");
        }
    };
    private static final FileFilter _dirFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    public static String[] getJavaFiles(File root) {
        LinkedList<String> javaFileNames = new LinkedList<String>();
        Util.descend(root, "", javaFileNames);
        return javaFileNames.toArray(new String[javaFileNames.size()]);
    }

    public static String getPackageNameFor(String qualifiedName) {
        String packageName = null;
        int lastDotIndex = qualifiedName.lastIndexOf(46);
        packageName = lastDotIndex == -1 ? "" : qualifiedName.substring(0, lastDotIndex);
        return packageName;
    }

    public static String getQualifiedNameFor(String packageName, String unqualifiedName) {
        if (packageName.equals("")) {
            return unqualifiedName;
        }
        return String.valueOf(packageName) + "." + unqualifiedName;
    }

    public static final StringBuffer appendDimensionAsString(int n, StringBuffer sb) {
        int i = 0;
        while (i < n) {
            sb.append("[]");
            ++i;
        }
        return sb;
    }

    public static final String toString(Object[] array, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i].toString());
            if (i < array.length - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String classNameFromQualifiedClassName(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("qualifiedName can't be null!");
        }
        int dot_index = qualifiedName.lastIndexOf(46);
        if (dot_index != -1) {
            return qualifiedName.substring(dot_index + 1);
        }
        return qualifiedName;
    }

    private static void descend(File root, String dirName, LinkedList<String> javaFileNames) {
        File dir = new File(root, dirName);
        File[] javaFiles = dir.listFiles(_javaFilter);
        int i = 0;
        while (i < javaFiles.length) {
            StringBuffer javaFileName = new StringBuffer();
            if (dirName.length() != 0) {
                javaFileName.append(dirName).append(File.separator);
            }
            javaFileName.append(javaFiles[i].getName());
            javaFileNames.add(javaFileName.toString());
            ++i;
        }
        File[] subDirs = dir.listFiles(_dirFilter);
        int i2 = 0;
        while (i2 < subDirs.length) {
            StringBuffer subDirName = new StringBuffer(dirName);
            if (dirName.length() != 0) {
                subDirName.append(File.separator);
            }
            subDirName.append(subDirs[i2].getName());
            Util.descend(root, subDirName.toString(), javaFileNames);
            ++i2;
        }
    }

    public static String getQualifiedInterfaceName(String javasourceName) {
        String temp = javasourceName.replace(File.separatorChar, '.');
        return temp.substring(0, temp.lastIndexOf("."));
    }
}

