/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet.filesystem;

import com.meidusa.venus.doclet.filesystem.DocletSource;
import com.meidusa.venus.doclet.filesystem.FileSourceSet;
import com.meidusa.venus.doclet.filesystem.Util;
import com.meidusa.venus.doclet.metainfo.engine.CommentScanner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSourceFilter {
    protected static Logger log = LoggerFactory.getLogger(FileSourceFilter.class);

    public static List<DocletSource> getForDocletFileSet(FileSourceSet fs) {
        ArrayList<DocletSource> docletFileSet = new ArrayList<DocletSource>();
        ArrayList<String> sourceFiles = fs.getJavasourceFiles();
        for (String javasourceName : sourceFiles) {
            File srcfile = new File(fs.getRootDir(), javasourceName);
            try {
                if (!FileSourceFilter.isIDLFile(srcfile)) continue;
                DocletSource docletSource = new DocletSource();
                docletSource.setInterfaceFile(srcfile);
                docletSource.setQualifiedInterfaceName(Util.getQualifiedInterfaceName(javasourceName));
                docletFileSet.add(docletSource);
            }
            catch (IOException e) {
                log.error("generator docletSource error : " + e.getMessage());
            }
        }
        return docletFileSet;
    }

    public static boolean isIDLFile(File sourceFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(FileSourceFilter.getFileReader(sourceFile));
        while ((line = reader.readLine()) != null) {
            if (!CommentScanner.containInterface(line)) continue;
            return true;
        }
        return false;
    }

    public static BufferedReader getFileReader(File sourceFile) {
        FileInputStream in = null;
        InputStreamReader reader = null;
        try {
            in = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException e) {
            log.error("source file error file :" + sourceFile.getName() + " " + e.getMessage());
        }
        reader = new InputStreamReader((InputStream)in, Charset.forName("GBK"));
        return new BufferedReader(reader);
    }

    public static void main(String[] args) throws IOException {
        FileSourceSet fs = new FileSourceSet(new File("/home/gaoyong/mail2.0_Refactoring/service-helloworld/trunk/src/main/java/"));
        FileSourceFilter.getForDocletFileSet(fs);
    }
}

