/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet.engine;

import com.meidusa.venus.doclet.ProjectInfo;
import com.meidusa.venus.doclet.classloader.AppJarClassLoader;
import com.meidusa.venus.doclet.filesystem.DocletSource;
import com.meidusa.venus.doclet.filesystem.FileSourceFilter;
import com.meidusa.venus.doclet.filesystem.FileSourceSet;
import com.meidusa.venus.doclet.metainfo.EndpointInfo;
import com.meidusa.venus.doclet.metainfo.EndpointParameterInfo;
import com.meidusa.venus.doclet.metainfo.MetaInfoLoaderUtil;
import com.meidusa.venus.doclet.metainfo.MethodInfo;
import com.meidusa.venus.doclet.metainfo.ParamInfo;
import com.meidusa.venus.doclet.metainfo.ServiceInfo;
import com.meidusa.venus.doclet.metainfo.engine.CommentScanner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentGenerator {
    protected static Logger log = LoggerFactory.getLogger(DocumentGenerator.class);
    private static String logTag = "api_template.vm";
    private AppJarClassLoader appJarClassLoader;

    public DocumentGenerator(AppJarClassLoader appJarClassLoader) {
        this.appJarClassLoader = appJarClassLoader;
    }

    public void generateDoclet(ProjectInfo projectInfo) {
        FileSourceSet fs = new FileSourceSet(projectInfo.getSourceDirectory());
        List<DocletSource> docletFileSet = FileSourceFilter.getForDocletFileSet(fs);
        for (DocletSource ds : docletFileSet) {
            this.handleDoclet(ds, projectInfo);
        }
    }

    private void handleDoclet(DocletSource ds, ProjectInfo projectInfo) {
        ArrayList<MethodInfo> mList = new ArrayList();
        try {
            mList = CommentScanner.scanPlainSource(FileSourceFilter.getFileReader(ds.getInterfaceFile()));
        }
        catch (IOException e) {
            log.error("handleDoclet error DocletSource generate error " + e.getMessage());
        }
        Class<?> clazz = null;
        try {
            clazz = this.appJarClassLoader.loadClass(ds.getQualifiedInterfaceName());
        }
        catch (ClassNotFoundException e) {
            log.error("handleDoclet error : " + e.getMessage());
        }
        this.renderTemlate(clazz, mList, projectInfo);
    }

    private void renderTemlate(Class<?> clazz, List<MethodInfo> mList, ProjectInfo projectInfo) {
        block12: {
            VelocityContext context = new VelocityContext();
            context = this.fillServiceContext(context, clazz);
            context = this.fillMethodContext(context, clazz, mList);
            Reader reader = this.createReader();
            Writer writer = DocumentGenerator.createWriter(projectInfo);
            try {
                try {
                    Velocity.evaluate((Context)context, (Writer)writer, (String)logTag, (Reader)reader);
                    writer.flush();
                }
                catch (IOException e) {
                    log.error("writer close failed :" + e.getMessage());
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        log.error("writer close failed :" + e2.getMessage());
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error("writer close failed :" + e.getMessage());
                    }
                }
            }
        }
    }

    private void mergeTemplate(VelocityContext context, Writer writer) {
        Template template = null;
        try {
            template = Velocity.getTemplate((String)"api_template.vm");
            template.merge((Context)context, writer);
        }
        catch (ResourceNotFoundException e) {
            log.error("merge temlate error : " + e.getMessage());
        }
        catch (ParseErrorException e) {
            log.error("merge temlate error : " + e.getMessage());
        }
        catch (Exception e) {
            log.error("merge temlate error : " + e.getMessage());
        }
    }

    private Reader createReader() {
        ClasspathResourceLoader cla = new ClasspathResourceLoader();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(cla.getResourceStream("/api_template.vm"), "UTF-8");
        }
        catch (ResourceNotFoundException e) {
            log.error("createReader error :" + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.error("createReader error :" + e.getMessage());
        }
        return reader;
    }

    private static Writer createWriter(ProjectInfo projectInfo) {
        BufferedWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(projectInfo.getOutputDocument());
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("generator writer fail :" + e.getMessage());
            }
        }
        catch (FileNotFoundException e1) {
            log.error("file not found : " + e1.getMessage());
        }
        return writer;
    }

    private VelocityContext fillServiceContext(VelocityContext context, Class<?> clazz) {
        ServiceInfo serviceInfo = MetaInfoLoaderUtil.getServiceMetaInfo(clazz);
        context.put("serviceName", (Object)serviceInfo.getShortClassName());
        return context;
    }

    private VelocityContext fillMethodContext(VelocityContext context, Class<?> clazz, List<MethodInfo> mList) {
        Method[] methods = clazz.getDeclaredMethods();
        MethodInfo[] methodInfos = new MethodInfo[methods.length];
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            EndpointInfo endpointInfo = MetaInfoLoaderUtil.getEndpointMetaInfo(m);
            for (MethodInfo methodInfo : mList) {
                EndpointParameterInfo[] params;
                if (!endpointInfo.getEndpointName().equals(methodInfo.getInterfaceName())) continue;
                methodInfo.setInterfaceName(endpointInfo.getEndpointName());
                methodInfo.setInvokeStyle(endpointInfo.getAsync());
                methodInfo.setReturnType(endpointInfo.getReturnType());
                List<ParamInfo> paramComments = methodInfo.getParamList();
                Iterator<ParamInfo> it = paramComments.iterator();
                EndpointParameterInfo[] endpointParameterInfoArray = params = MetaInfoLoaderUtil.getEndpointParameterMetaInfo(m);
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    EndpointParameterInfo endpoint = endpointParameterInfoArray[n2];
                    endpoint.setParamComent(" ");
                    while (it.hasNext()) {
                        ParamInfo paramInfo = it.next();
                        if (!endpoint.getName().equals(paramInfo.getParamName())) continue;
                        endpoint.setParamComent(paramInfo.getParamComent());
                        break;
                    }
                    ++n2;
                }
                methodInfo.setParams(params);
                methodInfos[i] = methodInfo;
                break;
            }
            ++i;
        }
        context.put("methods", (Object)methodInfos);
        return context;
    }

    public static void main(String[] args) throws SecurityException, NoSuchMethodException {
        String targetDir = "/home/gaoyong/mail2.0_Refactoring/service-helloworld/trunk/target/";
        String targetJar = "service-helloworld-1.0.0-SNAPSHOT.jar";
        File sourceDirectory = new File("/home/gaoyong/mail2.0_Refactoring/service-helloworld/trunk/src/main/java/");
        File jarFile = new File(new File(targetDir), targetJar);
        File document = new File(new File("/home/gaoyong/mail2.0_Refactoring/velocitytest/"), "testTemplate.html");
        ArrayList<File> jars = new ArrayList<File>();
        jars.add(jarFile);
        jars.add(new File("/home/gaoyong/.m2/repository/com/meidusa/venus/commons/service-common-exception/1.0.0-SNAPSHOT/service-common-exception-1.0.0-SNAPSHOT.jar"));
        jars.add(new File("/home/gaoyong/.m2/repository/com/meidusa/venus/commons/service-common-base/1.0.0-SNAPSHOT/service-common-base-1.0.0-SNAPSHOT.jar"));
        ProjectInfo info = new ProjectInfo();
        info.setOutputDocument(document);
        info.setSourceDirectory(sourceDirectory);
    }
}

