/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.doclet;

import com.meidusa.venus.doclet.ProjectInfo;
import com.meidusa.venus.doclet.classloader.AppJarClassLoader;
import com.meidusa.venus.doclet.engine.DocumentGenerator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletMojo
extends AbstractMojo {
    protected static Logger log = LoggerFactory.getLogger(DocletMojo.class);
    private File outputDirectory;
    private File sourceDirectory;
    private String documentName;
    private MavenProject project;
    private String finalName;
    private String packaging;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.setSourceDirectory(this.sourceDirectory);
        projectInfo.setOutputDocument(new File(this.outputDirectory, this.documentName));
        AppJarClassLoader appJarClassLoader = AppJarClassLoader.getAppJarClassLoader(this.processJarURLs(this.processDependencies()), Thread.currentThread().getContextClassLoader());
        DocumentGenerator documentGenerator = new DocumentGenerator(appJarClassLoader);
        documentGenerator.generateDoclet(projectInfo);
    }

    private List<File> processDependencies() {
        ArrayList<File> dependencyJars = new ArrayList<File>();
        Set dependencyArtifacts = this.project.getArtifacts();
        for (Artifact dependency : dependencyArtifacts) {
            if (dependency.getFile() == null) continue;
            dependencyJars.add(dependency.getFile());
        }
        if (this.packaging.equals("jar")) {
            dependencyJars.add(new File(this.outputDirectory, String.valueOf(this.finalName) + ".jar"));
        }
        this.packaging.equals("war");
        return dependencyJars;
    }

    private URL[] processJarURLs(List<File> jarFiles) {
        ArrayList<URL> dependencyJarurls = new ArrayList<URL>();
        for (File jarFile : jarFiles) {
            try {
                dependencyJarurls.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("processClassloader about jarurl error " + e.getMessage());
            }
        }
        return dependencyJarurls.toArray(new URL[dependencyJarurls.size()]);
    }
}

