/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.validator;

import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;

public class StringLengthFieldValidator
extends FieldValidatorSupport {
    private boolean doTrim = true;
    private int maxLength = -1;
    private int minLength = -1;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setTrim(boolean trim) {
        this.doTrim = trim;
    }

    public boolean getTrim() {
        return this.doTrim;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        if (object == null) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String val = (String)object;
        if (this.doTrim) {
            val = val.trim();
        }
        if (this.minLength > -1 && val.length() < this.minLength) {
            this.addFieldValidationError(fieldName, object);
        } else if (this.maxLength > -1 && val.length() > this.maxLength) {
            this.addFieldValidationError(fieldName, object);
        }
    }
}

