/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.util.dom;

import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.util.ClassLoaderUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DomHelper {
    private static String VENUS_VALIDATOR_DEFINITION_DTD = "venus-validator-definition-1.0.0.dtd";
    private static String VENUS_VALIDATOR_DTD = "venus-validator-1.0.0.dtd";
    private static Logger logger = LoggerFactory.getLogger(DomHelper.class);

    public static List<Element> findChilds(Element parent, String name) {
        ArrayList<Element> retElements = new ArrayList<Element>();
        if (parent != null) {
            NodeList rootList = parent.getChildNodes();
            for (int i = 0; i < rootList.getLength(); ++i) {
                Element e;
                Node nd = rootList.item(i);
                if (!(nd instanceof Element) || !name.equals((e = (Element)nd).getNodeName())) continue;
                retElements.add(e);
            }
        }
        return retElements;
    }

    public static Document parse(InputStream is, Map<String, String> dtdMappings) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(dtdMappings != null);
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new ValidationRuntimeException("Unable to create SAXParser", e);
        }
        DOMBuilder builder = new DOMBuilder();
        try {
            parser.parse(is, (DefaultHandler)new StartHandler(builder, dtdMappings));
        }
        catch (Exception e) {
            throw new ValidationRuntimeException("Cannot parse input", e);
        }
        return builder.getDocument();
    }

    public static class StartHandler
    extends DefaultHandler {
        private ContentHandler nextHandler;

        public StartHandler(ContentHandler next, Map<String, String> dtdMappings) {
            this.nextHandler = next;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.nextHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.nextHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.nextHandler.endDocument();
        }

        @Override
        public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            this.nextHandler.startElement(uri, loc, raw, attrs);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.nextHandler.endElement(arg0, arg1, arg2);
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.nextHandler.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.nextHandler.endPrefixMapping(arg0);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.nextHandler.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.nextHandler.skippedEntity(arg0);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.endsWith(VENUS_VALIDATOR_DTD)) {
                return new InputSource(ClassLoaderUtil.getResourceAsStream(VENUS_VALIDATOR_DTD, this.getClass()));
            }
            if (systemId.endsWith(VENUS_VALIDATOR_DEFINITION_DTD)) {
                return new InputSource(ClassLoaderUtil.getResourceAsStream(VENUS_VALIDATOR_DTD, this.getClass()));
            }
            try {
                return new InputSource(new FileInputStream(systemId));
            }
            catch (FileNotFoundException e) {
                logger.error("can't find dtd file");
                return null;
            }
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage() + " at (" + exception.getPublicId() + ":" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")", (Throwable)exception);
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage() + " at (" + exception.getPublicId() + ":" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")", (Throwable)exception);
            throw exception;
        }
    }

    public static class DOMBuilder
    implements ContentHandler {
        protected static SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
        protected SAXTransformerFactory factory;
        protected DOMResult result;
        protected Node parentNode;
        protected ContentHandler nextHandler;

        public DOMBuilder() {
            this((Node)null);
        }

        public DOMBuilder(SAXTransformerFactory factory) {
            this(factory, null);
        }

        public DOMBuilder(Node parentNode) {
            this(null, parentNode);
        }

        public DOMBuilder(SAXTransformerFactory factory, Node parentNode) {
            this.factory = factory == null ? FACTORY : factory;
            this.parentNode = parentNode;
            this.setup();
        }

        private void setup() {
            try {
                TransformerHandler handler = this.factory.newTransformerHandler();
                this.nextHandler = handler;
                this.result = this.parentNode != null ? new DOMResult(this.parentNode) : new DOMResult();
                handler.setResult(this.result);
            }
            catch (TransformerException local) {
                throw new ValidationRuntimeException("Fatal-Error: Unable to get transformer handler", local);
            }
        }

        public Document getDocument() {
            if (this.result == null || this.result.getNode() == null) {
                return null;
            }
            if (this.result.getNode().getNodeType() == 9) {
                return (Document)this.result.getNode();
            }
            return this.result.getNode().getOwnerDocument();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.nextHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.nextHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.nextHandler.endDocument();
        }

        @Override
        public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            this.nextHandler.startElement(uri, loc, raw, attrs);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.nextHandler.endElement(arg0, arg1, arg2);
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.nextHandler.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.nextHandler.endPrefixMapping(arg0);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.nextHandler.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.nextHandler.skippedEntity(arg0);
        }
    }
}

