/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.file;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.chain.VenusValidatorChain;
import com.meidusa.venus.validate.exception.ValidationRuntimeException;
import com.meidusa.venus.validate.file.DefaultFilePathGenerator;
import com.meidusa.venus.validate.file.FilePathGenerator;
import com.meidusa.venus.validate.file.ValidationFileInfo;
import com.meidusa.venus.validate.file.ValidationFileParser;
import com.meidusa.venus.validate.util.ClassLoaderUtil;
import com.meidusa.venus.validate.util.dom.DomHelper;
import com.meidusa.venus.validate.validator.FieldValidatorSupport;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.ValidatorSupport;
import com.meidusa.venus.validate.validator.VisitorFieldValidator;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultValidationFileParser
implements ValidationFileParser {
    private FilePathGenerator pathGenerator;
    private static String TYPE = "type";
    private static String FIELD_NAME = "fieldName";
    private static String XML_ELEMENT_FIELD = "field";
    private static String XML_ATTRIBUTE_NAME = "name";
    private static String XML_ELEMENT_FIELD_VALIDATOR = "field-validator";
    private static String XML_ATTRIBUTE_TYPE = "type";
    private static String XML_ELEMENT_PROPERTY = "property";
    private static String XML_ELEMENT_VALIDATOR = "validator";
    private static String XML_ATTRIBUTE_CLASS = "class";
    private static String VALIDATION_DEFINITION_FILE = "validator-definition.xml";
    private Map<String, Class<?>> validatorDefinition = new HashMap();

    public DefaultValidationFileParser() {
        this.initValidatorDefinition();
        this.pathGenerator = new DefaultFilePathGenerator();
    }

    @Override
    public ValidatorChain parseValidationConfigs(ValidationFileInfo info) {
        String path = this.pathGenerator.getConfigPath(info);
        VenusValidatorChain retChain = new VenusValidatorChain();
        InputStream is = ClassLoaderUtil.getResourceAsStream(path, this.getClass());
        if (is == null) {
            return retChain;
        }
        Document validationDoc = DomHelper.parse(is, null);
        Element rootElement = validationDoc.getDocumentElement();
        this.analyzeValidators(rootElement, retChain);
        List<Element> fieldElements = DomHelper.findChilds(rootElement, XML_ELEMENT_FIELD);
        for (Element element : fieldElements) {
            this.analyzeField(element, retChain, info);
        }
        return retChain;
    }

    private void analyzeValidators(Element validatorElement, ValidatorChain retValidators) {
        List<Element> exprValidators = DomHelper.findChilds(validatorElement, XML_ELEMENT_VALIDATOR);
        Iterator<Element> iterator = exprValidators.iterator();
        while (iterator.hasNext()) {
            retValidators.addValidator(this.analyzeValidator(iterator.next()));
        }
    }

    private void analyzeField(Element fieldElement, ValidatorChain retValidators, ValidationFileInfo info) {
        String fieldName = fieldElement.getAttribute(XML_ATTRIBUTE_NAME);
        for (Element fieldValidatorElement : DomHelper.findChilds(fieldElement, XML_ELEMENT_FIELD_VALIDATOR)) {
            retValidators.addValidator(this.analyzeFieldValidator(fieldValidatorElement, fieldName, info));
        }
    }

    private Validator analyzeValidator(Element validator) {
        HashMap<String, String> validatorConfigs = new HashMap<String, String>();
        String typeAttributes = validator.getAttribute(XML_ATTRIBUTE_TYPE);
        validatorConfigs.put(TYPE, typeAttributes);
        List<Element> paramElements = DomHelper.findChilds(validator, XML_ELEMENT_PROPERTY);
        for (Element paramElement : paramElements) {
            String name = paramElement.getAttribute(XML_ATTRIBUTE_NAME);
            String value = paramElement.getTextContent();
            validatorConfigs.put(name, value);
        }
        ValidatorSupport retValidator = null;
        Class<?> validatorClass = this.validatorDefinition.get(typeAttributes);
        try {
            retValidator = (ValidatorSupport)validatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ValidationRuntimeException("can't instantiate validator" + validatorClass.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ValidationRuntimeException("can't access validator class" + validatorClass.toString(), e);
        }
        try {
            BeanUtils.populate((Object)retValidator, validatorConfigs);
        }
        catch (Exception e) {
            throw new ValidationRuntimeException("cannot init validator", e);
        }
        return retValidator;
    }

    private Validator analyzeFieldValidator(Element fieldElement, String fieldName, ValidationFileInfo info) {
        HashMap<String, String> validatorConfigs = new HashMap<String, String>();
        String typeAttributes = fieldElement.getAttribute(XML_ATTRIBUTE_TYPE);
        validatorConfigs.put(TYPE, typeAttributes);
        if (fieldName != null && fieldName.length() > 0) {
            validatorConfigs.put(FIELD_NAME, fieldName);
        }
        List<Element> paramElements = DomHelper.findChilds(fieldElement, XML_ELEMENT_PROPERTY);
        for (Element paramElement : paramElements) {
            String name = paramElement.getAttribute(XML_ATTRIBUTE_NAME);
            String value = paramElement.getTextContent();
            validatorConfigs.put(name, value);
        }
        FieldValidatorSupport retValidator = null;
        Class<?> validatorClass = this.validatorDefinition.get(typeAttributes);
        try {
            retValidator = (FieldValidatorSupport)validatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ValidationRuntimeException("can't instantiate validator" + validatorClass.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ValidationRuntimeException("can't access validator class" + validatorClass.toString(), e);
        }
        try {
            BeanUtils.populate((Object)retValidator, validatorConfigs);
        }
        catch (Exception e) {
            throw new ValidationRuntimeException("cannot init validator", e);
        }
        if (retValidator instanceof VisitorFieldValidator) {
            String path = ((VisitorFieldValidator)retValidator).getPath();
            if (path == null || path.length() == 0) {
                info.addInner(fieldName);
                path = this.pathGenerator.getConfigPath(info);
            }
            ValidatorChain chain = this.parseValidationConfigs(info);
            ((VisitorFieldValidator)retValidator).setInternalValidatorChain(chain);
        }
        return retValidator;
    }

    private void initValidatorDefinition() {
        InputStream definitionInputStream = ClassLoaderUtil.getResourceAsStream(VALIDATION_DEFINITION_FILE, this.getClass());
        this.parseValidationDefinitions(definitionInputStream);
    }

    public void parseValidationDefinitions(InputStream is) {
        Document definitionDoc = DomHelper.parse(is, null);
        List<Element> definitions = DomHelper.findChilds(definitionDoc.getDocumentElement(), XML_ELEMENT_VALIDATOR);
        for (Element validatorElement : definitions) {
            Class<?> validatorClass;
            String name = validatorElement.getAttribute(XML_ATTRIBUTE_NAME);
            String className = validatorElement.getAttribute(XML_ATTRIBUTE_CLASS);
            try {
                validatorClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ValidationRuntimeException("Can't find class" + className, e);
            }
            this.validatorDefinition.put(name, validatorClass);
        }
    }

    static {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setPatterns(new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"});
        ConvertUtils.register((Converter)dateConverter, Date.class);
    }
}

