/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.chain;

import com.meidusa.venus.validate.chain.ValidatorChain;
import com.meidusa.venus.validate.exception.ValidationException;
import com.meidusa.venus.validate.holder.OgnlBasicValueHolder;
import com.meidusa.venus.validate.validator.FieldValidator;
import com.meidusa.venus.validate.validator.Validator;
import com.meidusa.venus.validate.validator.ValidatorSupport;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class VenusValidatorChain
implements ValidatorChain {
    private List<Validator> expression = new ArrayList<Validator>();
    private Map<String, List<FieldValidator>> fieldValidators = new HashMap<String, List<FieldValidator>>();

    @Override
    public void validate(Object params) throws ValidationException {
        OgnlBasicValueHolder paramsHolder = new OgnlBasicValueHolder(params);
        for (Map.Entry<String, List<FieldValidator>> entry : this.fieldValidators.entrySet()) {
            try {
                for (FieldValidator validator : entry.getValue()) {
                    validator.validate(this.getProperty(params, entry.getKey()));
                }
            }
            catch (Exception e) {
                if (e instanceof ValidationException) {
                    throw (ValidationException)e;
                }
                throw new ValidationException("can't get property " + entry.getKey(), e);
            }
        }
        for (Validator validator : this.expression) {
            ValidatorSupport paramsValidator = (ValidatorSupport)validator;
            ((ValidatorSupport)validator).setValueHolder(paramsHolder);
            paramsValidator.validate(params);
        }
    }

    private Object getProperty(Object o, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (o.getClass().isArray()) {
            return Array.get(o, Integer.valueOf(propertyName.substring(5)));
        }
        return PropertyUtils.getProperty((Object)o, (String)propertyName);
    }

    @Override
    public void addValidator(Validator validator) {
        if (validator instanceof FieldValidator) {
            List<FieldValidator> fieldValidatorList = this.fieldValidators.get(((FieldValidator)validator).getFieldName());
            if (fieldValidatorList == null) {
                fieldValidatorList = new LinkedList<FieldValidator>();
                this.fieldValidators.put(((FieldValidator)validator).getFieldName(), fieldValidatorList);
            }
            fieldValidatorList.add((FieldValidator)validator);
        } else {
            this.expression.add(validator);
        }
    }
}

